// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a text column.
 */
@Fluent
public final class MicrosoftGraphTextColumn implements JsonSerializable<MicrosoftGraphTextColumn> {
    /*
     * Whether to allow multiple lines of text.
     */
    private Boolean allowMultipleLines;

    /*
     * Whether updates to this column should replace existing text, or append to it.
     */
    private Boolean appendChangesToExistingText;

    /*
     * The size of the text box.
     */
    private Integer linesForEditing;

    /*
     * The maximum number of characters for the value.
     */
    private Integer maxLength;

    /*
     * The type of text being stored. Must be one of plain or richText
     */
    private String textType;

    /*
     * textColumn
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTextColumn class.
     */
    public MicrosoftGraphTextColumn() {
    }

    /**
     * Get the allowMultipleLines property: Whether to allow multiple lines of text.
     * 
     * @return the allowMultipleLines value.
     */
    public Boolean allowMultipleLines() {
        return this.allowMultipleLines;
    }

    /**
     * Set the allowMultipleLines property: Whether to allow multiple lines of text.
     * 
     * @param allowMultipleLines the allowMultipleLines value to set.
     * @return the MicrosoftGraphTextColumn object itself.
     */
    public MicrosoftGraphTextColumn withAllowMultipleLines(Boolean allowMultipleLines) {
        this.allowMultipleLines = allowMultipleLines;
        return this;
    }

    /**
     * Get the appendChangesToExistingText property: Whether updates to this column should replace existing text, or
     * append to it.
     * 
     * @return the appendChangesToExistingText value.
     */
    public Boolean appendChangesToExistingText() {
        return this.appendChangesToExistingText;
    }

    /**
     * Set the appendChangesToExistingText property: Whether updates to this column should replace existing text, or
     * append to it.
     * 
     * @param appendChangesToExistingText the appendChangesToExistingText value to set.
     * @return the MicrosoftGraphTextColumn object itself.
     */
    public MicrosoftGraphTextColumn withAppendChangesToExistingText(Boolean appendChangesToExistingText) {
        this.appendChangesToExistingText = appendChangesToExistingText;
        return this;
    }

    /**
     * Get the linesForEditing property: The size of the text box.
     * 
     * @return the linesForEditing value.
     */
    public Integer linesForEditing() {
        return this.linesForEditing;
    }

    /**
     * Set the linesForEditing property: The size of the text box.
     * 
     * @param linesForEditing the linesForEditing value to set.
     * @return the MicrosoftGraphTextColumn object itself.
     */
    public MicrosoftGraphTextColumn withLinesForEditing(Integer linesForEditing) {
        this.linesForEditing = linesForEditing;
        return this;
    }

    /**
     * Get the maxLength property: The maximum number of characters for the value.
     * 
     * @return the maxLength value.
     */
    public Integer maxLength() {
        return this.maxLength;
    }

    /**
     * Set the maxLength property: The maximum number of characters for the value.
     * 
     * @param maxLength the maxLength value to set.
     * @return the MicrosoftGraphTextColumn object itself.
     */
    public MicrosoftGraphTextColumn withMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    /**
     * Get the textType property: The type of text being stored. Must be one of plain or richText.
     * 
     * @return the textType value.
     */
    public String textType() {
        return this.textType;
    }

    /**
     * Set the textType property: The type of text being stored. Must be one of plain or richText.
     * 
     * @param textType the textType value to set.
     * @return the MicrosoftGraphTextColumn object itself.
     */
    public MicrosoftGraphTextColumn withTextType(String textType) {
        this.textType = textType;
        return this;
    }

    /**
     * Get the additionalProperties property: textColumn.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: textColumn.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTextColumn object itself.
     */
    public MicrosoftGraphTextColumn withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowMultipleLines", this.allowMultipleLines);
        jsonWriter.writeBooleanField("appendChangesToExistingText", this.appendChangesToExistingText);
        jsonWriter.writeNumberField("linesForEditing", this.linesForEditing);
        jsonWriter.writeNumberField("maxLength", this.maxLength);
        jsonWriter.writeStringField("textType", this.textType);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTextColumn from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTextColumn if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTextColumn.
     */
    public static MicrosoftGraphTextColumn fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTextColumn deserializedMicrosoftGraphTextColumn = new MicrosoftGraphTextColumn();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowMultipleLines".equals(fieldName)) {
                    deserializedMicrosoftGraphTextColumn.allowMultipleLines
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("appendChangesToExistingText".equals(fieldName)) {
                    deserializedMicrosoftGraphTextColumn.appendChangesToExistingText
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("linesForEditing".equals(fieldName)) {
                    deserializedMicrosoftGraphTextColumn.linesForEditing = reader.getNullable(JsonReader::getInt);
                } else if ("maxLength".equals(fieldName)) {
                    deserializedMicrosoftGraphTextColumn.maxLength = reader.getNullable(JsonReader::getInt);
                } else if ("textType".equals(fieldName)) {
                    deserializedMicrosoftGraphTextColumn.textType = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTextColumn.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTextColumn;
        });
    }
}
