// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a teams tab configuration.
 */
@Fluent
public final class MicrosoftGraphTeamsTabConfiguration
    implements JsonSerializable<MicrosoftGraphTeamsTabConfiguration> {
    /*
     * Url used for rendering tab contents in Teams. Required.
     */
    private String contentUrl;

    /*
     * Identifier for the entity hosted by the tab provider.
     */
    private String entityId;

    /*
     * Url called by Teams client when a Tab is removed using the Teams Client.
     */
    private String removeUrl;

    /*
     * Url for showing tab contents outside of Teams.
     */
    private String websiteUrl;

    /*
     * teamsTabConfiguration
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTeamsTabConfiguration class.
     */
    public MicrosoftGraphTeamsTabConfiguration() {
    }

    /**
     * Get the contentUrl property: Url used for rendering tab contents in Teams. Required.
     * 
     * @return the contentUrl value.
     */
    public String contentUrl() {
        return this.contentUrl;
    }

    /**
     * Set the contentUrl property: Url used for rendering tab contents in Teams. Required.
     * 
     * @param contentUrl the contentUrl value to set.
     * @return the MicrosoftGraphTeamsTabConfiguration object itself.
     */
    public MicrosoftGraphTeamsTabConfiguration withContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
        return this;
    }

    /**
     * Get the entityId property: Identifier for the entity hosted by the tab provider.
     * 
     * @return the entityId value.
     */
    public String entityId() {
        return this.entityId;
    }

    /**
     * Set the entityId property: Identifier for the entity hosted by the tab provider.
     * 
     * @param entityId the entityId value to set.
     * @return the MicrosoftGraphTeamsTabConfiguration object itself.
     */
    public MicrosoftGraphTeamsTabConfiguration withEntityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    /**
     * Get the removeUrl property: Url called by Teams client when a Tab is removed using the Teams Client.
     * 
     * @return the removeUrl value.
     */
    public String removeUrl() {
        return this.removeUrl;
    }

    /**
     * Set the removeUrl property: Url called by Teams client when a Tab is removed using the Teams Client.
     * 
     * @param removeUrl the removeUrl value to set.
     * @return the MicrosoftGraphTeamsTabConfiguration object itself.
     */
    public MicrosoftGraphTeamsTabConfiguration withRemoveUrl(String removeUrl) {
        this.removeUrl = removeUrl;
        return this;
    }

    /**
     * Get the websiteUrl property: Url for showing tab contents outside of Teams.
     * 
     * @return the websiteUrl value.
     */
    public String websiteUrl() {
        return this.websiteUrl;
    }

    /**
     * Set the websiteUrl property: Url for showing tab contents outside of Teams.
     * 
     * @param websiteUrl the websiteUrl value to set.
     * @return the MicrosoftGraphTeamsTabConfiguration object itself.
     */
    public MicrosoftGraphTeamsTabConfiguration withWebsiteUrl(String websiteUrl) {
        this.websiteUrl = websiteUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: teamsTabConfiguration.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: teamsTabConfiguration.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTeamsTabConfiguration object itself.
     */
    public MicrosoftGraphTeamsTabConfiguration withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentUrl", this.contentUrl);
        jsonWriter.writeStringField("entityId", this.entityId);
        jsonWriter.writeStringField("removeUrl", this.removeUrl);
        jsonWriter.writeStringField("websiteUrl", this.websiteUrl);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTeamsTabConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTeamsTabConfiguration if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTeamsTabConfiguration.
     */
    public static MicrosoftGraphTeamsTabConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTeamsTabConfiguration deserializedMicrosoftGraphTeamsTabConfiguration
                = new MicrosoftGraphTeamsTabConfiguration();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("contentUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsTabConfiguration.contentUrl = reader.getString();
                } else if ("entityId".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsTabConfiguration.entityId = reader.getString();
                } else if ("removeUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsTabConfiguration.removeUrl = reader.getString();
                } else if ("websiteUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsTabConfiguration.websiteUrl = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTeamsTabConfiguration.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTeamsTabConfiguration;
        });
    }
}
