// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a teams tab.
 */
@Fluent
public final class MicrosoftGraphTeamsTab extends MicrosoftGraphEntity {
    /*
     * teamsTabConfiguration
     */
    private MicrosoftGraphTeamsTabConfiguration configuration;

    /*
     * Name of the tab.
     */
    private String displayName;

    /*
     * Deep link URL of the tab instance. Read only.
     */
    private String webUrl;

    /*
     * teamsApp
     */
    private MicrosoftGraphTeamsApp teamsApp;

    /*
     * teamsTab
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTeamsTab class.
     */
    public MicrosoftGraphTeamsTab() {
    }

    /**
     * Get the configuration property: teamsTabConfiguration.
     * 
     * @return the configuration value.
     */
    public MicrosoftGraphTeamsTabConfiguration configuration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: teamsTabConfiguration.
     * 
     * @param configuration the configuration value to set.
     * @return the MicrosoftGraphTeamsTab object itself.
     */
    public MicrosoftGraphTeamsTab withConfiguration(MicrosoftGraphTeamsTabConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Get the displayName property: Name of the tab.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Name of the tab.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphTeamsTab object itself.
     */
    public MicrosoftGraphTeamsTab withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the webUrl property: Deep link URL of the tab instance. Read only.
     * 
     * @return the webUrl value.
     */
    public String webUrl() {
        return this.webUrl;
    }

    /**
     * Set the webUrl property: Deep link URL of the tab instance. Read only.
     * 
     * @param webUrl the webUrl value to set.
     * @return the MicrosoftGraphTeamsTab object itself.
     */
    public MicrosoftGraphTeamsTab withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    /**
     * Get the teamsApp property: teamsApp.
     * 
     * @return the teamsApp value.
     */
    public MicrosoftGraphTeamsApp teamsApp() {
        return this.teamsApp;
    }

    /**
     * Set the teamsApp property: teamsApp.
     * 
     * @param teamsApp the teamsApp value to set.
     * @return the MicrosoftGraphTeamsTab object itself.
     */
    public MicrosoftGraphTeamsTab withTeamsApp(MicrosoftGraphTeamsApp teamsApp) {
        this.teamsApp = teamsApp;
        return this;
    }

    /**
     * Get the additionalProperties property: teamsTab.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: teamsTab.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTeamsTab object itself.
     */
    public MicrosoftGraphTeamsTab withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphTeamsTab withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (configuration() != null) {
            configuration().validate();
        }
        if (teamsApp() != null) {
            teamsApp().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("configuration", this.configuration);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("webUrl", this.webUrl);
        jsonWriter.writeJsonField("teamsApp", this.teamsApp);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTeamsTab from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTeamsTab if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTeamsTab.
     */
    public static MicrosoftGraphTeamsTab fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTeamsTab deserializedMicrosoftGraphTeamsTab = new MicrosoftGraphTeamsTab();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsTab.withId(reader.getString());
                } else if ("configuration".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsTab.configuration
                        = MicrosoftGraphTeamsTabConfiguration.fromJson(reader);
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsTab.displayName = reader.getString();
                } else if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsTab.webUrl = reader.getString();
                } else if ("teamsApp".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsTab.teamsApp = MicrosoftGraphTeamsApp.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTeamsTab.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTeamsTab;
        });
    }
}
