// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a team messaging settings.
 */
@Fluent
public final class MicrosoftGraphTeamMessagingSettings
    implements JsonSerializable<MicrosoftGraphTeamMessagingSettings> {
    /*
     * If set to true, @channel mentions are allowed.
     */
    private Boolean allowChannelMentions;

    /*
     * If set to true, owners can delete any message.
     */
    private Boolean allowOwnerDeleteMessages;

    /*
     * If set to true, @team mentions are allowed.
     */
    private Boolean allowTeamMentions;

    /*
     * If set to true, users can delete their messages.
     */
    private Boolean allowUserDeleteMessages;

    /*
     * If set to true, users can edit their messages.
     */
    private Boolean allowUserEditMessages;

    /*
     * teamMessagingSettings
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTeamMessagingSettings class.
     */
    public MicrosoftGraphTeamMessagingSettings() {
    }

    /**
     * Get the allowChannelMentions property: If set to true, &#064;channel mentions are allowed.
     * 
     * @return the allowChannelMentions value.
     */
    public Boolean allowChannelMentions() {
        return this.allowChannelMentions;
    }

    /**
     * Set the allowChannelMentions property: If set to true, &#064;channel mentions are allowed.
     * 
     * @param allowChannelMentions the allowChannelMentions value to set.
     * @return the MicrosoftGraphTeamMessagingSettings object itself.
     */
    public MicrosoftGraphTeamMessagingSettings withAllowChannelMentions(Boolean allowChannelMentions) {
        this.allowChannelMentions = allowChannelMentions;
        return this;
    }

    /**
     * Get the allowOwnerDeleteMessages property: If set to true, owners can delete any message.
     * 
     * @return the allowOwnerDeleteMessages value.
     */
    public Boolean allowOwnerDeleteMessages() {
        return this.allowOwnerDeleteMessages;
    }

    /**
     * Set the allowOwnerDeleteMessages property: If set to true, owners can delete any message.
     * 
     * @param allowOwnerDeleteMessages the allowOwnerDeleteMessages value to set.
     * @return the MicrosoftGraphTeamMessagingSettings object itself.
     */
    public MicrosoftGraphTeamMessagingSettings withAllowOwnerDeleteMessages(Boolean allowOwnerDeleteMessages) {
        this.allowOwnerDeleteMessages = allowOwnerDeleteMessages;
        return this;
    }

    /**
     * Get the allowTeamMentions property: If set to true, &#064;team mentions are allowed.
     * 
     * @return the allowTeamMentions value.
     */
    public Boolean allowTeamMentions() {
        return this.allowTeamMentions;
    }

    /**
     * Set the allowTeamMentions property: If set to true, &#064;team mentions are allowed.
     * 
     * @param allowTeamMentions the allowTeamMentions value to set.
     * @return the MicrosoftGraphTeamMessagingSettings object itself.
     */
    public MicrosoftGraphTeamMessagingSettings withAllowTeamMentions(Boolean allowTeamMentions) {
        this.allowTeamMentions = allowTeamMentions;
        return this;
    }

    /**
     * Get the allowUserDeleteMessages property: If set to true, users can delete their messages.
     * 
     * @return the allowUserDeleteMessages value.
     */
    public Boolean allowUserDeleteMessages() {
        return this.allowUserDeleteMessages;
    }

    /**
     * Set the allowUserDeleteMessages property: If set to true, users can delete their messages.
     * 
     * @param allowUserDeleteMessages the allowUserDeleteMessages value to set.
     * @return the MicrosoftGraphTeamMessagingSettings object itself.
     */
    public MicrosoftGraphTeamMessagingSettings withAllowUserDeleteMessages(Boolean allowUserDeleteMessages) {
        this.allowUserDeleteMessages = allowUserDeleteMessages;
        return this;
    }

    /**
     * Get the allowUserEditMessages property: If set to true, users can edit their messages.
     * 
     * @return the allowUserEditMessages value.
     */
    public Boolean allowUserEditMessages() {
        return this.allowUserEditMessages;
    }

    /**
     * Set the allowUserEditMessages property: If set to true, users can edit their messages.
     * 
     * @param allowUserEditMessages the allowUserEditMessages value to set.
     * @return the MicrosoftGraphTeamMessagingSettings object itself.
     */
    public MicrosoftGraphTeamMessagingSettings withAllowUserEditMessages(Boolean allowUserEditMessages) {
        this.allowUserEditMessages = allowUserEditMessages;
        return this;
    }

    /**
     * Get the additionalProperties property: teamMessagingSettings.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: teamMessagingSettings.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTeamMessagingSettings object itself.
     */
    public MicrosoftGraphTeamMessagingSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowChannelMentions", this.allowChannelMentions);
        jsonWriter.writeBooleanField("allowOwnerDeleteMessages", this.allowOwnerDeleteMessages);
        jsonWriter.writeBooleanField("allowTeamMentions", this.allowTeamMentions);
        jsonWriter.writeBooleanField("allowUserDeleteMessages", this.allowUserDeleteMessages);
        jsonWriter.writeBooleanField("allowUserEditMessages", this.allowUserEditMessages);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTeamMessagingSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTeamMessagingSettings if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTeamMessagingSettings.
     */
    public static MicrosoftGraphTeamMessagingSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTeamMessagingSettings deserializedMicrosoftGraphTeamMessagingSettings
                = new MicrosoftGraphTeamMessagingSettings();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowChannelMentions".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamMessagingSettings.allowChannelMentions
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowOwnerDeleteMessages".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamMessagingSettings.allowOwnerDeleteMessages
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowTeamMentions".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamMessagingSettings.allowTeamMentions
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowUserDeleteMessages".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamMessagingSettings.allowUserDeleteMessages
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowUserEditMessages".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamMessagingSettings.allowUserEditMessages
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTeamMessagingSettings.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTeamMessagingSettings;
        });
    }
}
