// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a subscription.
 */
@Fluent
public final class MicrosoftGraphSubscription extends MicrosoftGraphEntity {
    /*
     * Identifier of the application used to create the subscription. Read-only.
     */
    private String applicationId;

    /*
     * Required. Indicates the type of change in the subscribed resource that will raise a change notification. The
     * supported values are: created, updated, deleted. Multiple values can be combined using a comma-separated
     * list.Note: Drive root item and list change notifications support only the updated changeType. User and group
     * change notifications support updated and deleted changeType.
     */
    private String changeType;

    /*
     * Optional. Specifies the value of the clientState property sent by the service in each change notification. The
     * maximum length is 128 characters. The client can check that the change notification came from the service by
     * comparing the value of the clientState property sent with the subscription with the value of the clientState
     * property received with each change notification.
     */
    private String clientState;

    /*
     * Identifier of the user or service principal that created the subscription. If the app used delegated permissions
     * to create the subscription, this field contains the id of the signed-in user the app called on behalf of. If the
     * app used application permissions, this field contains the id of the service principal corresponding to the app.
     * Read-only.
     */
    private String creatorId;

    /*
     * A base64-encoded representation of a certificate with a public key used to encrypt resource data in change
     * notifications. Optional. Required when includeResourceData is true.
     */
    private String encryptionCertificate;

    /*
     * A custom app-provided identifier to help identify the certificate needed to decrypt resource data. Optional.
     */
    private String encryptionCertificateId;

    /*
     * Required. Specifies the date and time when the webhook subscription expires. The time is in UTC, and can be an
     * amount of time from subscription creation that varies for the resource subscribed to. See the table below for
     * maximum supported subscription length of time.
     */
    private OffsetDateTime expirationDateTime;

    /*
     * When set to true, change notifications include resource data (such as content of a chat message). Optional.
     */
    private Boolean includeResourceData;

    /*
     * Specifies the latest version of Transport Layer Security (TLS) that the notification endpoint, specified by
     * notificationUrl, supports. The possible values are: v1_0, v1_1, v1_2, v1_3. For subscribers whose notification
     * endpoint supports a version lower than the currently recommended version (TLS 1.2), specifying this property by a
     * set timeline allows them to temporarily use their deprecated version of TLS before completing their upgrade to
     * TLS 1.2. For these subscribers, not setting this property per the timeline would result in subscription
     * operations failing. For subscribers whose notification endpoint already supports TLS 1.2, setting this property
     * is optional. In such cases, Microsoft Graph defaults the property to v1_2.
     */
    private String latestSupportedTlsVersion;

    /*
     * The URL of the endpoint that receives lifecycle notifications, including subscriptionRemoved and missed
     * notifications. This URL must make use of the HTTPS protocol. Optional. Read more about how Outlook resources use
     * lifecycle notifications.
     */
    private String lifecycleNotificationUrl;

    /*
     * Required. The URL of the endpoint that will receive the change notifications. This URL must make use of the HTTPS
     * protocol.
     */
    private String notificationUrl;

    /*
     * Required. Specifies the resource that will be monitored for changes. Do not include the base URL
     * (https://graph.microsoft.com/v1.0/). See the possible resource path values for each supported resource.
     */
    private String resource;

    /*
     * subscription
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSubscription class.
     */
    public MicrosoftGraphSubscription() {
    }

    /**
     * Get the applicationId property: Identifier of the application used to create the subscription. Read-only.
     * 
     * @return the applicationId value.
     */
    public String applicationId() {
        return this.applicationId;
    }

    /**
     * Set the applicationId property: Identifier of the application used to create the subscription. Read-only.
     * 
     * @param applicationId the applicationId value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    /**
     * Get the changeType property: Required. Indicates the type of change in the subscribed resource that will raise a
     * change notification. The supported values are: created, updated, deleted. Multiple values can be combined using a
     * comma-separated list.Note: Drive root item and list change notifications support only the updated changeType.
     * User and group change notifications support updated and deleted changeType.
     * 
     * @return the changeType value.
     */
    public String changeType() {
        return this.changeType;
    }

    /**
     * Set the changeType property: Required. Indicates the type of change in the subscribed resource that will raise a
     * change notification. The supported values are: created, updated, deleted. Multiple values can be combined using a
     * comma-separated list.Note: Drive root item and list change notifications support only the updated changeType.
     * User and group change notifications support updated and deleted changeType.
     * 
     * @param changeType the changeType value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withChangeType(String changeType) {
        this.changeType = changeType;
        return this;
    }

    /**
     * Get the clientState property: Optional. Specifies the value of the clientState property sent by the service in
     * each change notification. The maximum length is 128 characters. The client can check that the change notification
     * came from the service by comparing the value of the clientState property sent with the subscription with the
     * value of the clientState property received with each change notification.
     * 
     * @return the clientState value.
     */
    public String clientState() {
        return this.clientState;
    }

    /**
     * Set the clientState property: Optional. Specifies the value of the clientState property sent by the service in
     * each change notification. The maximum length is 128 characters. The client can check that the change notification
     * came from the service by comparing the value of the clientState property sent with the subscription with the
     * value of the clientState property received with each change notification.
     * 
     * @param clientState the clientState value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withClientState(String clientState) {
        this.clientState = clientState;
        return this;
    }

    /**
     * Get the creatorId property: Identifier of the user or service principal that created the subscription. If the app
     * used delegated permissions to create the subscription, this field contains the id of the signed-in user the app
     * called on behalf of. If the app used application permissions, this field contains the id of the service principal
     * corresponding to the app. Read-only.
     * 
     * @return the creatorId value.
     */
    public String creatorId() {
        return this.creatorId;
    }

    /**
     * Set the creatorId property: Identifier of the user or service principal that created the subscription. If the app
     * used delegated permissions to create the subscription, this field contains the id of the signed-in user the app
     * called on behalf of. If the app used application permissions, this field contains the id of the service principal
     * corresponding to the app. Read-only.
     * 
     * @param creatorId the creatorId value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withCreatorId(String creatorId) {
        this.creatorId = creatorId;
        return this;
    }

    /**
     * Get the encryptionCertificate property: A base64-encoded representation of a certificate with a public key used
     * to encrypt resource data in change notifications. Optional. Required when includeResourceData is true.
     * 
     * @return the encryptionCertificate value.
     */
    public String encryptionCertificate() {
        return this.encryptionCertificate;
    }

    /**
     * Set the encryptionCertificate property: A base64-encoded representation of a certificate with a public key used
     * to encrypt resource data in change notifications. Optional. Required when includeResourceData is true.
     * 
     * @param encryptionCertificate the encryptionCertificate value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withEncryptionCertificate(String encryptionCertificate) {
        this.encryptionCertificate = encryptionCertificate;
        return this;
    }

    /**
     * Get the encryptionCertificateId property: A custom app-provided identifier to help identify the certificate
     * needed to decrypt resource data. Optional.
     * 
     * @return the encryptionCertificateId value.
     */
    public String encryptionCertificateId() {
        return this.encryptionCertificateId;
    }

    /**
     * Set the encryptionCertificateId property: A custom app-provided identifier to help identify the certificate
     * needed to decrypt resource data. Optional.
     * 
     * @param encryptionCertificateId the encryptionCertificateId value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withEncryptionCertificateId(String encryptionCertificateId) {
        this.encryptionCertificateId = encryptionCertificateId;
        return this;
    }

    /**
     * Get the expirationDateTime property: Required. Specifies the date and time when the webhook subscription expires.
     * The time is in UTC, and can be an amount of time from subscription creation that varies for the resource
     * subscribed to. See the table below for maximum supported subscription length of time.
     * 
     * @return the expirationDateTime value.
     */
    public OffsetDateTime expirationDateTime() {
        return this.expirationDateTime;
    }

    /**
     * Set the expirationDateTime property: Required. Specifies the date and time when the webhook subscription expires.
     * The time is in UTC, and can be an amount of time from subscription creation that varies for the resource
     * subscribed to. See the table below for maximum supported subscription length of time.
     * 
     * @param expirationDateTime the expirationDateTime value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    /**
     * Get the includeResourceData property: When set to true, change notifications include resource data (such as
     * content of a chat message). Optional.
     * 
     * @return the includeResourceData value.
     */
    public Boolean includeResourceData() {
        return this.includeResourceData;
    }

    /**
     * Set the includeResourceData property: When set to true, change notifications include resource data (such as
     * content of a chat message). Optional.
     * 
     * @param includeResourceData the includeResourceData value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withIncludeResourceData(Boolean includeResourceData) {
        this.includeResourceData = includeResourceData;
        return this;
    }

    /**
     * Get the latestSupportedTlsVersion property: Specifies the latest version of Transport Layer Security (TLS) that
     * the notification endpoint, specified by notificationUrl, supports. The possible values are: v1_0, v1_1, v1_2,
     * v1_3. For subscribers whose notification endpoint supports a version lower than the currently recommended version
     * (TLS 1.2), specifying this property by a set timeline allows them to temporarily use their deprecated version of
     * TLS before completing their upgrade to TLS 1.2. For these subscribers, not setting this property per the timeline
     * would result in subscription operations failing. For subscribers whose notification endpoint already supports TLS
     * 1.2, setting this property is optional. In such cases, Microsoft Graph defaults the property to v1_2.
     * 
     * @return the latestSupportedTlsVersion value.
     */
    public String latestSupportedTlsVersion() {
        return this.latestSupportedTlsVersion;
    }

    /**
     * Set the latestSupportedTlsVersion property: Specifies the latest version of Transport Layer Security (TLS) that
     * the notification endpoint, specified by notificationUrl, supports. The possible values are: v1_0, v1_1, v1_2,
     * v1_3. For subscribers whose notification endpoint supports a version lower than the currently recommended version
     * (TLS 1.2), specifying this property by a set timeline allows them to temporarily use their deprecated version of
     * TLS before completing their upgrade to TLS 1.2. For these subscribers, not setting this property per the timeline
     * would result in subscription operations failing. For subscribers whose notification endpoint already supports TLS
     * 1.2, setting this property is optional. In such cases, Microsoft Graph defaults the property to v1_2.
     * 
     * @param latestSupportedTlsVersion the latestSupportedTlsVersion value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withLatestSupportedTlsVersion(String latestSupportedTlsVersion) {
        this.latestSupportedTlsVersion = latestSupportedTlsVersion;
        return this;
    }

    /**
     * Get the lifecycleNotificationUrl property: The URL of the endpoint that receives lifecycle notifications,
     * including subscriptionRemoved and missed notifications. This URL must make use of the HTTPS protocol. Optional.
     * Read more about how Outlook resources use lifecycle notifications.
     * 
     * @return the lifecycleNotificationUrl value.
     */
    public String lifecycleNotificationUrl() {
        return this.lifecycleNotificationUrl;
    }

    /**
     * Set the lifecycleNotificationUrl property: The URL of the endpoint that receives lifecycle notifications,
     * including subscriptionRemoved and missed notifications. This URL must make use of the HTTPS protocol. Optional.
     * Read more about how Outlook resources use lifecycle notifications.
     * 
     * @param lifecycleNotificationUrl the lifecycleNotificationUrl value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withLifecycleNotificationUrl(String lifecycleNotificationUrl) {
        this.lifecycleNotificationUrl = lifecycleNotificationUrl;
        return this;
    }

    /**
     * Get the notificationUrl property: Required. The URL of the endpoint that will receive the change notifications.
     * This URL must make use of the HTTPS protocol.
     * 
     * @return the notificationUrl value.
     */
    public String notificationUrl() {
        return this.notificationUrl;
    }

    /**
     * Set the notificationUrl property: Required. The URL of the endpoint that will receive the change notifications.
     * This URL must make use of the HTTPS protocol.
     * 
     * @param notificationUrl the notificationUrl value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
        return this;
    }

    /**
     * Get the resource property: Required. Specifies the resource that will be monitored for changes. Do not include
     * the base URL (https://graph.microsoft.com/v1.0/). See the possible resource path values for each supported
     * resource.
     * 
     * @return the resource value.
     */
    public String resource() {
        return this.resource;
    }

    /**
     * Set the resource property: Required. Specifies the resource that will be monitored for changes. Do not include
     * the base URL (https://graph.microsoft.com/v1.0/). See the possible resource path values for each supported
     * resource.
     * 
     * @param resource the resource value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withResource(String resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the additionalProperties property: subscription.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: subscription.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSubscription object itself.
     */
    public MicrosoftGraphSubscription withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSubscription withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("applicationId", this.applicationId);
        jsonWriter.writeStringField("changeType", this.changeType);
        jsonWriter.writeStringField("clientState", this.clientState);
        jsonWriter.writeStringField("creatorId", this.creatorId);
        jsonWriter.writeStringField("encryptionCertificate", this.encryptionCertificate);
        jsonWriter.writeStringField("encryptionCertificateId", this.encryptionCertificateId);
        jsonWriter.writeStringField("expirationDateTime",
            this.expirationDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        jsonWriter.writeBooleanField("includeResourceData", this.includeResourceData);
        jsonWriter.writeStringField("latestSupportedTlsVersion", this.latestSupportedTlsVersion);
        jsonWriter.writeStringField("lifecycleNotificationUrl", this.lifecycleNotificationUrl);
        jsonWriter.writeStringField("notificationUrl", this.notificationUrl);
        jsonWriter.writeStringField("resource", this.resource);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSubscription from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSubscription if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSubscription.
     */
    public static MicrosoftGraphSubscription fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSubscription deserializedMicrosoftGraphSubscription = new MicrosoftGraphSubscription();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.withId(reader.getString());
                } else if ("applicationId".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.applicationId = reader.getString();
                } else if ("changeType".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.changeType = reader.getString();
                } else if ("clientState".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.clientState = reader.getString();
                } else if ("creatorId".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.creatorId = reader.getString();
                } else if ("encryptionCertificate".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.encryptionCertificate = reader.getString();
                } else if ("encryptionCertificateId".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.encryptionCertificateId = reader.getString();
                } else if ("expirationDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.expirationDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("includeResourceData".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.includeResourceData
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("latestSupportedTlsVersion".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.latestSupportedTlsVersion = reader.getString();
                } else if ("lifecycleNotificationUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.lifecycleNotificationUrl = reader.getString();
                } else if ("notificationUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.notificationUrl = reader.getString();
                } else if ("resource".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscription.resource = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSubscription.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSubscription;
        });
    }
}
