// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a sts policy.
 * <p>
 * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
 * entity types.
 */
@Fluent
public class MicrosoftGraphStsPolicy extends MicrosoftGraphPolicyBase {
    /*
     * A string collection containing a JSON string that defines the rules and settings for a policy. The syntax for the
     * definition differs for each derived policy type. Required.
     */
    private List<String> definition;

    /*
     * If set to true, activates this policy. There can be many policies for the same policy type, but only one can be
     * activated as the organization default. Optional, default value is false.
     */
    private Boolean isOrganizationDefault;

    /*
     * The appliesTo property.
     */
    private List<MicrosoftGraphDirectoryObjectInner> appliesTo;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
     * entity types.
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphStsPolicy class.
     */
    public MicrosoftGraphStsPolicy() {
    }

    /**
     * Get the definition property: A string collection containing a JSON string that defines the rules and settings for
     * a policy. The syntax for the definition differs for each derived policy type. Required.
     * 
     * @return the definition value.
     */
    public List<String> definition() {
        return this.definition;
    }

    /**
     * Set the definition property: A string collection containing a JSON string that defines the rules and settings for
     * a policy. The syntax for the definition differs for each derived policy type. Required.
     * 
     * @param definition the definition value to set.
     * @return the MicrosoftGraphStsPolicy object itself.
     */
    public MicrosoftGraphStsPolicy withDefinition(List<String> definition) {
        this.definition = definition;
        return this;
    }

    /**
     * Get the isOrganizationDefault property: If set to true, activates this policy. There can be many policies for the
     * same policy type, but only one can be activated as the organization default. Optional, default value is false.
     * 
     * @return the isOrganizationDefault value.
     */
    public Boolean isOrganizationDefault() {
        return this.isOrganizationDefault;
    }

    /**
     * Set the isOrganizationDefault property: If set to true, activates this policy. There can be many policies for the
     * same policy type, but only one can be activated as the organization default. Optional, default value is false.
     * 
     * @param isOrganizationDefault the isOrganizationDefault value to set.
     * @return the MicrosoftGraphStsPolicy object itself.
     */
    public MicrosoftGraphStsPolicy withIsOrganizationDefault(Boolean isOrganizationDefault) {
        this.isOrganizationDefault = isOrganizationDefault;
        return this;
    }

    /**
     * Get the appliesTo property: The appliesTo property.
     * 
     * @return the appliesTo value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> appliesTo() {
        return this.appliesTo;
    }

    /**
     * Set the appliesTo property: The appliesTo property.
     * 
     * @param appliesTo the appliesTo value to set.
     * @return the MicrosoftGraphStsPolicy object itself.
     */
    public MicrosoftGraphStsPolicy withAppliesTo(List<MicrosoftGraphDirectoryObjectInner> appliesTo) {
        this.appliesTo = appliesTo;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphStsPolicy object itself.
     */
    public MicrosoftGraphStsPolicy withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphStsPolicy withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphStsPolicy withDisplayName(String displayName) {
        super.withDisplayName(displayName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphStsPolicy withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphStsPolicy withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (appliesTo() != null) {
            appliesTo().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("deletedDateTime",
            deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(deletedDateTime()));
        jsonWriter.writeStringField("description", description());
        jsonWriter.writeStringField("displayName", displayName());
        jsonWriter.writeArrayField("definition", this.definition, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isOrganizationDefault", this.isOrganizationDefault);
        jsonWriter.writeArrayField("appliesTo", this.appliesTo, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphStsPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphStsPolicy if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphStsPolicy.
     */
    public static MicrosoftGraphStsPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphStsPolicy deserializedMicrosoftGraphStsPolicy = new MicrosoftGraphStsPolicy();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphStsPolicy.withId(reader.getString());
                } else if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphStsPolicy.withDeletedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphStsPolicy.withDescription(reader.getString());
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphStsPolicy.withDisplayName(reader.getString());
                } else if ("definition".equals(fieldName)) {
                    List<String> definition = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphStsPolicy.definition = definition;
                } else if ("isOrganizationDefault".equals(fieldName)) {
                    deserializedMicrosoftGraphStsPolicy.isOrganizationDefault
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("appliesTo".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> appliesTo
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphStsPolicy.appliesTo = appliesTo;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphStsPolicy.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphStsPolicy;
        });
    }
}
