// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a storage plan information.
 */
@Fluent
public final class MicrosoftGraphStoragePlanInformation
    implements JsonSerializable<MicrosoftGraphStoragePlanInformation> {
    /*
     * Indicates whether there are higher storage quota plans available. Read-only.
     */
    private Boolean upgradeAvailable;

    /*
     * storagePlanInformation
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphStoragePlanInformation class.
     */
    public MicrosoftGraphStoragePlanInformation() {
    }

    /**
     * Get the upgradeAvailable property: Indicates whether there are higher storage quota plans available. Read-only.
     * 
     * @return the upgradeAvailable value.
     */
    public Boolean upgradeAvailable() {
        return this.upgradeAvailable;
    }

    /**
     * Set the upgradeAvailable property: Indicates whether there are higher storage quota plans available. Read-only.
     * 
     * @param upgradeAvailable the upgradeAvailable value to set.
     * @return the MicrosoftGraphStoragePlanInformation object itself.
     */
    public MicrosoftGraphStoragePlanInformation withUpgradeAvailable(Boolean upgradeAvailable) {
        this.upgradeAvailable = upgradeAvailable;
        return this;
    }

    /**
     * Get the additionalProperties property: storagePlanInformation.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: storagePlanInformation.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphStoragePlanInformation object itself.
     */
    public MicrosoftGraphStoragePlanInformation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("upgradeAvailable", this.upgradeAvailable);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphStoragePlanInformation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphStoragePlanInformation if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphStoragePlanInformation.
     */
    public static MicrosoftGraphStoragePlanInformation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphStoragePlanInformation deserializedMicrosoftGraphStoragePlanInformation
                = new MicrosoftGraphStoragePlanInformation();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("upgradeAvailable".equals(fieldName)) {
                    deserializedMicrosoftGraphStoragePlanInformation.upgradeAvailable
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphStoragePlanInformation.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphStoragePlanInformation;
        });
    }
}
