// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a shift availability.
 */
@Fluent
public final class MicrosoftGraphShiftAvailability implements JsonSerializable<MicrosoftGraphShiftAvailability> {
    /*
     * patternedRecurrence
     */
    private MicrosoftGraphPatternedRecurrence recurrence;

    /*
     * The time slot(s) preferred by the user.
     */
    private List<MicrosoftGraphTimeRange> timeSlots;

    /*
     * Specifies the time zone for the indicated time.
     */
    private String timeZone;

    /*
     * shiftAvailability
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphShiftAvailability class.
     */
    public MicrosoftGraphShiftAvailability() {
    }

    /**
     * Get the recurrence property: patternedRecurrence.
     * 
     * @return the recurrence value.
     */
    public MicrosoftGraphPatternedRecurrence recurrence() {
        return this.recurrence;
    }

    /**
     * Set the recurrence property: patternedRecurrence.
     * 
     * @param recurrence the recurrence value to set.
     * @return the MicrosoftGraphShiftAvailability object itself.
     */
    public MicrosoftGraphShiftAvailability withRecurrence(MicrosoftGraphPatternedRecurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    /**
     * Get the timeSlots property: The time slot(s) preferred by the user.
     * 
     * @return the timeSlots value.
     */
    public List<MicrosoftGraphTimeRange> timeSlots() {
        return this.timeSlots;
    }

    /**
     * Set the timeSlots property: The time slot(s) preferred by the user.
     * 
     * @param timeSlots the timeSlots value to set.
     * @return the MicrosoftGraphShiftAvailability object itself.
     */
    public MicrosoftGraphShiftAvailability withTimeSlots(List<MicrosoftGraphTimeRange> timeSlots) {
        this.timeSlots = timeSlots;
        return this;
    }

    /**
     * Get the timeZone property: Specifies the time zone for the indicated time.
     * 
     * @return the timeZone value.
     */
    public String timeZone() {
        return this.timeZone;
    }

    /**
     * Set the timeZone property: Specifies the time zone for the indicated time.
     * 
     * @param timeZone the timeZone value to set.
     * @return the MicrosoftGraphShiftAvailability object itself.
     */
    public MicrosoftGraphShiftAvailability withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    /**
     * Get the additionalProperties property: shiftAvailability.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: shiftAvailability.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphShiftAvailability object itself.
     */
    public MicrosoftGraphShiftAvailability withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (recurrence() != null) {
            recurrence().validate();
        }
        if (timeSlots() != null) {
            timeSlots().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recurrence", this.recurrence);
        jsonWriter.writeArrayField("timeSlots", this.timeSlots, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("timeZone", this.timeZone);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphShiftAvailability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphShiftAvailability if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphShiftAvailability.
     */
    public static MicrosoftGraphShiftAvailability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphShiftAvailability deserializedMicrosoftGraphShiftAvailability
                = new MicrosoftGraphShiftAvailability();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recurrence".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftAvailability.recurrence
                        = MicrosoftGraphPatternedRecurrence.fromJson(reader);
                } else if ("timeSlots".equals(fieldName)) {
                    List<MicrosoftGraphTimeRange> timeSlots
                        = reader.readArray(reader1 -> MicrosoftGraphTimeRange.fromJson(reader1));
                    deserializedMicrosoftGraphShiftAvailability.timeSlots = timeSlots;
                } else if ("timeZone".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftAvailability.timeZone = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphShiftAvailability.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphShiftAvailability;
        });
    }
}
