// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a shift activity.
 */
@Fluent
public final class MicrosoftGraphShiftActivity implements JsonSerializable<MicrosoftGraphShiftActivity> {
    /*
     * Customer defined code for the shiftActivity. Required.
     */
    private String code;

    /*
     * The name of the shiftActivity. Required.
     */
    private String displayName;

    /*
     * The end date and time for the shiftActivity. The Timestamp type represents date and time information using ISO
     * 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Required.
     */
    private OffsetDateTime endDateTime;

    /*
     * Indicates whether the microsoft.graph.user should be paid for the activity during their shift. Required.
     */
    private Boolean isPaid;

    /*
     * The start date and time for the shiftActivity. The Timestamp type represents date and time information using ISO
     * 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Required.
     */
    private OffsetDateTime startDateTime;

    /*
     * scheduleEntityTheme
     */
    private MicrosoftGraphScheduleEntityTheme theme;

    /*
     * shiftActivity
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphShiftActivity class.
     */
    public MicrosoftGraphShiftActivity() {
    }

    /**
     * Get the code property: Customer defined code for the shiftActivity. Required.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the code property: Customer defined code for the shiftActivity. Required.
     * 
     * @param code the code value to set.
     * @return the MicrosoftGraphShiftActivity object itself.
     */
    public MicrosoftGraphShiftActivity withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the displayName property: The name of the shiftActivity. Required.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The name of the shiftActivity. Required.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphShiftActivity object itself.
     */
    public MicrosoftGraphShiftActivity withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the endDateTime property: The end date and time for the shiftActivity. The Timestamp type represents date and
     * time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would
     * look like this: '2014-01-01T00:00:00Z'. Required.
     * 
     * @return the endDateTime value.
     */
    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    /**
     * Set the endDateTime property: The end date and time for the shiftActivity. The Timestamp type represents date and
     * time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would
     * look like this: '2014-01-01T00:00:00Z'. Required.
     * 
     * @param endDateTime the endDateTime value to set.
     * @return the MicrosoftGraphShiftActivity object itself.
     */
    public MicrosoftGraphShiftActivity withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    /**
     * Get the isPaid property: Indicates whether the microsoft.graph.user should be paid for the activity during their
     * shift. Required.
     * 
     * @return the isPaid value.
     */
    public Boolean isPaid() {
        return this.isPaid;
    }

    /**
     * Set the isPaid property: Indicates whether the microsoft.graph.user should be paid for the activity during their
     * shift. Required.
     * 
     * @param isPaid the isPaid value to set.
     * @return the MicrosoftGraphShiftActivity object itself.
     */
    public MicrosoftGraphShiftActivity withIsPaid(Boolean isPaid) {
        this.isPaid = isPaid;
        return this;
    }

    /**
     * Get the startDateTime property: The start date and time for the shiftActivity. The Timestamp type represents date
     * and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014
     * would look like this: '2014-01-01T00:00:00Z'. Required.
     * 
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: The start date and time for the shiftActivity. The Timestamp type represents date
     * and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014
     * would look like this: '2014-01-01T00:00:00Z'. Required.
     * 
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphShiftActivity object itself.
     */
    public MicrosoftGraphShiftActivity withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the theme property: scheduleEntityTheme.
     * 
     * @return the theme value.
     */
    public MicrosoftGraphScheduleEntityTheme theme() {
        return this.theme;
    }

    /**
     * Set the theme property: scheduleEntityTheme.
     * 
     * @param theme the theme value to set.
     * @return the MicrosoftGraphShiftActivity object itself.
     */
    public MicrosoftGraphShiftActivity withTheme(MicrosoftGraphScheduleEntityTheme theme) {
        this.theme = theme;
        return this;
    }

    /**
     * Get the additionalProperties property: shiftActivity.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: shiftActivity.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphShiftActivity object itself.
     */
    public MicrosoftGraphShiftActivity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("endDateTime",
            this.endDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime));
        jsonWriter.writeBooleanField("isPaid", this.isPaid);
        jsonWriter.writeStringField("startDateTime",
            this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeStringField("theme", this.theme == null ? null : this.theme.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphShiftActivity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphShiftActivity if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphShiftActivity.
     */
    public static MicrosoftGraphShiftActivity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphShiftActivity deserializedMicrosoftGraphShiftActivity = new MicrosoftGraphShiftActivity();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftActivity.code = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftActivity.displayName = reader.getString();
                } else if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftActivity.endDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("isPaid".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftActivity.isPaid = reader.getNullable(JsonReader::getBoolean);
                } else if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftActivity.startDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("theme".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftActivity.theme
                        = MicrosoftGraphScheduleEntityTheme.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphShiftActivity.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphShiftActivity;
        });
    }
}
