// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a sharing invitation.
 */
@Fluent
public final class MicrosoftGraphSharingInvitation implements JsonSerializable<MicrosoftGraphSharingInvitation> {
    /*
     * The email address provided for the recipient of the sharing invitation. Read-only.
     */
    private String email;

    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet invitedBy;

    /*
     * The redeemedBy property.
     */
    private String redeemedBy;

    /*
     * If true the recipient of the invitation needs to sign in in order to access the shared item. Read-only.
     */
    private Boolean signInRequired;

    /*
     * sharingInvitation
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSharingInvitation class.
     */
    public MicrosoftGraphSharingInvitation() {
    }

    /**
     * Get the email property: The email address provided for the recipient of the sharing invitation. Read-only.
     * 
     * @return the email value.
     */
    public String email() {
        return this.email;
    }

    /**
     * Set the email property: The email address provided for the recipient of the sharing invitation. Read-only.
     * 
     * @param email the email value to set.
     * @return the MicrosoftGraphSharingInvitation object itself.
     */
    public MicrosoftGraphSharingInvitation withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Get the invitedBy property: identitySet.
     * 
     * @return the invitedBy value.
     */
    public MicrosoftGraphIdentitySet invitedBy() {
        return this.invitedBy;
    }

    /**
     * Set the invitedBy property: identitySet.
     * 
     * @param invitedBy the invitedBy value to set.
     * @return the MicrosoftGraphSharingInvitation object itself.
     */
    public MicrosoftGraphSharingInvitation withInvitedBy(MicrosoftGraphIdentitySet invitedBy) {
        this.invitedBy = invitedBy;
        return this;
    }

    /**
     * Get the redeemedBy property: The redeemedBy property.
     * 
     * @return the redeemedBy value.
     */
    public String redeemedBy() {
        return this.redeemedBy;
    }

    /**
     * Set the redeemedBy property: The redeemedBy property.
     * 
     * @param redeemedBy the redeemedBy value to set.
     * @return the MicrosoftGraphSharingInvitation object itself.
     */
    public MicrosoftGraphSharingInvitation withRedeemedBy(String redeemedBy) {
        this.redeemedBy = redeemedBy;
        return this;
    }

    /**
     * Get the signInRequired property: If true the recipient of the invitation needs to sign in in order to access the
     * shared item. Read-only.
     * 
     * @return the signInRequired value.
     */
    public Boolean signInRequired() {
        return this.signInRequired;
    }

    /**
     * Set the signInRequired property: If true the recipient of the invitation needs to sign in in order to access the
     * shared item. Read-only.
     * 
     * @param signInRequired the signInRequired value to set.
     * @return the MicrosoftGraphSharingInvitation object itself.
     */
    public MicrosoftGraphSharingInvitation withSignInRequired(Boolean signInRequired) {
        this.signInRequired = signInRequired;
        return this;
    }

    /**
     * Get the additionalProperties property: sharingInvitation.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: sharingInvitation.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSharingInvitation object itself.
     */
    public MicrosoftGraphSharingInvitation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (invitedBy() != null) {
            invitedBy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeJsonField("invitedBy", this.invitedBy);
        jsonWriter.writeStringField("redeemedBy", this.redeemedBy);
        jsonWriter.writeBooleanField("signInRequired", this.signInRequired);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSharingInvitation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSharingInvitation if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSharingInvitation.
     */
    public static MicrosoftGraphSharingInvitation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSharingInvitation deserializedMicrosoftGraphSharingInvitation
                = new MicrosoftGraphSharingInvitation();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("email".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingInvitation.email = reader.getString();
                } else if ("invitedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingInvitation.invitedBy = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("redeemedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingInvitation.redeemedBy = reader.getString();
                } else if ("signInRequired".equals(fieldName)) {
                    deserializedMicrosoftGraphSharingInvitation.signInRequired
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSharingInvitation.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSharingInvitation;
        });
    }
}
