// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a setting source.
 */
@Fluent
public final class MicrosoftGraphSettingSource implements JsonSerializable<MicrosoftGraphSettingSource> {
    /*
     * Not yet documented
     */
    private String displayName;

    /*
     * Not yet documented
     */
    private String id;

    /*
     * settingSource
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSettingSource class.
     */
    public MicrosoftGraphSettingSource() {
    }

    /**
     * Get the displayName property: Not yet documented.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Not yet documented.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphSettingSource object itself.
     */
    public MicrosoftGraphSettingSource withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the id property: Not yet documented.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Not yet documented.
     * 
     * @param id the id value to set.
     * @return the MicrosoftGraphSettingSource object itself.
     */
    public MicrosoftGraphSettingSource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the additionalProperties property: settingSource.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: settingSource.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSettingSource object itself.
     */
    public MicrosoftGraphSettingSource withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("id", this.id);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSettingSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSettingSource if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSettingSource.
     */
    public static MicrosoftGraphSettingSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSettingSource deserializedMicrosoftGraphSettingSource = new MicrosoftGraphSettingSource();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphSettingSource.displayName = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphSettingSource.id = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSettingSource.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSettingSource;
        });
    }
}
