// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

/**
 * Represents a service plan info.
 */
@Fluent
public final class MicrosoftGraphServicePlanInfo implements JsonSerializable<MicrosoftGraphServicePlanInfo> {
    /*
     * The object the service plan can be assigned to. Possible values:'User' - service plan can be assigned to
     * individual users.'Company' - service plan can be assigned to the entire tenant.
     */
    private String appliesTo;

    /*
     * The provisioning status of the service plan. Possible values:'Success' - Service is fully provisioned.'Disabled'
     * - Service has been disabled.'PendingInput' - Service is not yet provisioned; awaiting service
     * confirmation.'PendingActivation' - Service is provisioned but requires explicit activation by administrator (for
     * example, Intune_O365 service plan)'PendingProvisioning' - Microsoft has added a new service to the product SKU
     * and it has not been activated in the tenant, yet.
     */
    private String provisioningStatus;

    /*
     * The unique identifier of the service plan.
     */
    private UUID servicePlanId;

    /*
     * The name of the service plan.
     */
    private String servicePlanName;

    /*
     * servicePlanInfo
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphServicePlanInfo class.
     */
    public MicrosoftGraphServicePlanInfo() {
    }

    /**
     * Get the appliesTo property: The object the service plan can be assigned to. Possible values:'User' - service plan
     * can be assigned to individual users.'Company' - service plan can be assigned to the entire tenant.
     * 
     * @return the appliesTo value.
     */
    public String appliesTo() {
        return this.appliesTo;
    }

    /**
     * Set the appliesTo property: The object the service plan can be assigned to. Possible values:'User' - service plan
     * can be assigned to individual users.'Company' - service plan can be assigned to the entire tenant.
     * 
     * @param appliesTo the appliesTo value to set.
     * @return the MicrosoftGraphServicePlanInfo object itself.
     */
    public MicrosoftGraphServicePlanInfo withAppliesTo(String appliesTo) {
        this.appliesTo = appliesTo;
        return this;
    }

    /**
     * Get the provisioningStatus property: The provisioning status of the service plan. Possible values:'Success' -
     * Service is fully provisioned.'Disabled' - Service has been disabled.'PendingInput' - Service is not yet
     * provisioned; awaiting service confirmation.'PendingActivation' - Service is provisioned but requires explicit
     * activation by administrator (for example, Intune_O365 service plan)'PendingProvisioning' - Microsoft has added a
     * new service to the product SKU and it has not been activated in the tenant, yet.
     * 
     * @return the provisioningStatus value.
     */
    public String provisioningStatus() {
        return this.provisioningStatus;
    }

    /**
     * Set the provisioningStatus property: The provisioning status of the service plan. Possible values:'Success' -
     * Service is fully provisioned.'Disabled' - Service has been disabled.'PendingInput' - Service is not yet
     * provisioned; awaiting service confirmation.'PendingActivation' - Service is provisioned but requires explicit
     * activation by administrator (for example, Intune_O365 service plan)'PendingProvisioning' - Microsoft has added a
     * new service to the product SKU and it has not been activated in the tenant, yet.
     * 
     * @param provisioningStatus the provisioningStatus value to set.
     * @return the MicrosoftGraphServicePlanInfo object itself.
     */
    public MicrosoftGraphServicePlanInfo withProvisioningStatus(String provisioningStatus) {
        this.provisioningStatus = provisioningStatus;
        return this;
    }

    /**
     * Get the servicePlanId property: The unique identifier of the service plan.
     * 
     * @return the servicePlanId value.
     */
    public UUID servicePlanId() {
        return this.servicePlanId;
    }

    /**
     * Set the servicePlanId property: The unique identifier of the service plan.
     * 
     * @param servicePlanId the servicePlanId value to set.
     * @return the MicrosoftGraphServicePlanInfo object itself.
     */
    public MicrosoftGraphServicePlanInfo withServicePlanId(UUID servicePlanId) {
        this.servicePlanId = servicePlanId;
        return this;
    }

    /**
     * Get the servicePlanName property: The name of the service plan.
     * 
     * @return the servicePlanName value.
     */
    public String servicePlanName() {
        return this.servicePlanName;
    }

    /**
     * Set the servicePlanName property: The name of the service plan.
     * 
     * @param servicePlanName the servicePlanName value to set.
     * @return the MicrosoftGraphServicePlanInfo object itself.
     */
    public MicrosoftGraphServicePlanInfo withServicePlanName(String servicePlanName) {
        this.servicePlanName = servicePlanName;
        return this;
    }

    /**
     * Get the additionalProperties property: servicePlanInfo.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: servicePlanInfo.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphServicePlanInfo object itself.
     */
    public MicrosoftGraphServicePlanInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appliesTo", this.appliesTo);
        jsonWriter.writeStringField("provisioningStatus", this.provisioningStatus);
        jsonWriter.writeStringField("servicePlanId", Objects.toString(this.servicePlanId, null));
        jsonWriter.writeStringField("servicePlanName", this.servicePlanName);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphServicePlanInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphServicePlanInfo if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphServicePlanInfo.
     */
    public static MicrosoftGraphServicePlanInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphServicePlanInfo deserializedMicrosoftGraphServicePlanInfo
                = new MicrosoftGraphServicePlanInfo();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("appliesTo".equals(fieldName)) {
                    deserializedMicrosoftGraphServicePlanInfo.appliesTo = reader.getString();
                } else if ("provisioningStatus".equals(fieldName)) {
                    deserializedMicrosoftGraphServicePlanInfo.provisioningStatus = reader.getString();
                } else if ("servicePlanId".equals(fieldName)) {
                    deserializedMicrosoftGraphServicePlanInfo.servicePlanId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("servicePlanName".equals(fieldName)) {
                    deserializedMicrosoftGraphServicePlanInfo.servicePlanName = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphServicePlanInfo.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphServicePlanInfo;
        });
    }
}
