// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a search result.
 */
@Fluent
public final class MicrosoftGraphSearchResult implements JsonSerializable<MicrosoftGraphSearchResult> {
    /*
     * A callback URL that can be used to record telemetry information. The application should issue a GET on this URL
     * if the user interacts with this item to improve the quality of results.
     */
    private String onClickTelemetryUrl;

    /*
     * searchResult
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSearchResult class.
     */
    public MicrosoftGraphSearchResult() {
    }

    /**
     * Get the onClickTelemetryUrl property: A callback URL that can be used to record telemetry information. The
     * application should issue a GET on this URL if the user interacts with this item to improve the quality of
     * results.
     * 
     * @return the onClickTelemetryUrl value.
     */
    public String onClickTelemetryUrl() {
        return this.onClickTelemetryUrl;
    }

    /**
     * Set the onClickTelemetryUrl property: A callback URL that can be used to record telemetry information. The
     * application should issue a GET on this URL if the user interacts with this item to improve the quality of
     * results.
     * 
     * @param onClickTelemetryUrl the onClickTelemetryUrl value to set.
     * @return the MicrosoftGraphSearchResult object itself.
     */
    public MicrosoftGraphSearchResult withOnClickTelemetryUrl(String onClickTelemetryUrl) {
        this.onClickTelemetryUrl = onClickTelemetryUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: searchResult.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: searchResult.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSearchResult object itself.
     */
    public MicrosoftGraphSearchResult withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("onClickTelemetryUrl", this.onClickTelemetryUrl);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSearchResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSearchResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSearchResult.
     */
    public static MicrosoftGraphSearchResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSearchResult deserializedMicrosoftGraphSearchResult = new MicrosoftGraphSearchResult();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("onClickTelemetryUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphSearchResult.onClickTelemetryUrl = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSearchResult.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSearchResult;
        });
    }
}
