// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a schedule item.
 */
@Fluent
public final class MicrosoftGraphScheduleItem implements JsonSerializable<MicrosoftGraphScheduleItem> {
    /*
     * dateTimeTimeZone
     */
    private MicrosoftGraphDateTimeZone end;

    /*
     * The sensitivity of the corresponding event. True if the event is marked private, false otherwise. Optional.
     */
    private Boolean isPrivate;

    /*
     * The location where the corresponding event is held or attended from. Optional.
     */
    private String location;

    /*
     * dateTimeTimeZone
     */
    private MicrosoftGraphDateTimeZone start;

    /*
     * freeBusyStatus
     */
    private MicrosoftGraphFreeBusyStatus status;

    /*
     * The corresponding event's subject line. Optional.
     */
    private String subject;

    /*
     * scheduleItem
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphScheduleItem class.
     */
    public MicrosoftGraphScheduleItem() {
    }

    /**
     * Get the end property: dateTimeTimeZone.
     * 
     * @return the end value.
     */
    public MicrosoftGraphDateTimeZone end() {
        return this.end;
    }

    /**
     * Set the end property: dateTimeTimeZone.
     * 
     * @param end the end value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withEnd(MicrosoftGraphDateTimeZone end) {
        this.end = end;
        return this;
    }

    /**
     * Get the isPrivate property: The sensitivity of the corresponding event. True if the event is marked private,
     * false otherwise. Optional.
     * 
     * @return the isPrivate value.
     */
    public Boolean isPrivate() {
        return this.isPrivate;
    }

    /**
     * Set the isPrivate property: The sensitivity of the corresponding event. True if the event is marked private,
     * false otherwise. Optional.
     * 
     * @param isPrivate the isPrivate value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withIsPrivate(Boolean isPrivate) {
        this.isPrivate = isPrivate;
        return this;
    }

    /**
     * Get the location property: The location where the corresponding event is held or attended from. Optional.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location where the corresponding event is held or attended from. Optional.
     * 
     * @param location the location value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the start property: dateTimeTimeZone.
     * 
     * @return the start value.
     */
    public MicrosoftGraphDateTimeZone start() {
        return this.start;
    }

    /**
     * Set the start property: dateTimeTimeZone.
     * 
     * @param start the start value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withStart(MicrosoftGraphDateTimeZone start) {
        this.start = start;
        return this;
    }

    /**
     * Get the status property: freeBusyStatus.
     * 
     * @return the status value.
     */
    public MicrosoftGraphFreeBusyStatus status() {
        return this.status;
    }

    /**
     * Set the status property: freeBusyStatus.
     * 
     * @param status the status value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withStatus(MicrosoftGraphFreeBusyStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the subject property: The corresponding event's subject line. Optional.
     * 
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Set the subject property: The corresponding event's subject line. Optional.
     * 
     * @param subject the subject value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Get the additionalProperties property: scheduleItem.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: scheduleItem.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (end() != null) {
            end().validate();
        }
        if (start() != null) {
            start().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("end", this.end);
        jsonWriter.writeBooleanField("isPrivate", this.isPrivate);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("start", this.start);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("subject", this.subject);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphScheduleItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphScheduleItem if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphScheduleItem.
     */
    public static MicrosoftGraphScheduleItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphScheduleItem deserializedMicrosoftGraphScheduleItem = new MicrosoftGraphScheduleItem();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("end".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleItem.end = MicrosoftGraphDateTimeZone.fromJson(reader);
                } else if ("isPrivate".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleItem.isPrivate = reader.getNullable(JsonReader::getBoolean);
                } else if ("location".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleItem.location = reader.getString();
                } else if ("start".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleItem.start = MicrosoftGraphDateTimeZone.fromJson(reader);
                } else if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleItem.status
                        = MicrosoftGraphFreeBusyStatus.fromString(reader.getString());
                } else if ("subject".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleItem.subject = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphScheduleItem.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphScheduleItem;
        });
    }
}
