// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a schedule entity.
 */
@Fluent
public class MicrosoftGraphScheduleEntity implements JsonSerializable<MicrosoftGraphScheduleEntity> {
    /*
     * The endDateTime property.
     */
    private OffsetDateTime endDateTime;

    /*
     * The startDateTime property.
     */
    private OffsetDateTime startDateTime;

    /*
     * scheduleEntityTheme
     */
    private MicrosoftGraphScheduleEntityTheme theme;

    /*
     * scheduleEntity
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphScheduleEntity class.
     */
    public MicrosoftGraphScheduleEntity() {
    }

    /**
     * Get the endDateTime property: The endDateTime property.
     * 
     * @return the endDateTime value.
     */
    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    /**
     * Set the endDateTime property: The endDateTime property.
     * 
     * @param endDateTime the endDateTime value to set.
     * @return the MicrosoftGraphScheduleEntity object itself.
     */
    public MicrosoftGraphScheduleEntity withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    /**
     * Get the startDateTime property: The startDateTime property.
     * 
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: The startDateTime property.
     * 
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphScheduleEntity object itself.
     */
    public MicrosoftGraphScheduleEntity withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the theme property: scheduleEntityTheme.
     * 
     * @return the theme value.
     */
    public MicrosoftGraphScheduleEntityTheme theme() {
        return this.theme;
    }

    /**
     * Set the theme property: scheduleEntityTheme.
     * 
     * @param theme the theme value to set.
     * @return the MicrosoftGraphScheduleEntity object itself.
     */
    public MicrosoftGraphScheduleEntity withTheme(MicrosoftGraphScheduleEntityTheme theme) {
        this.theme = theme;
        return this;
    }

    /**
     * Get the additionalProperties property: scheduleEntity.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: scheduleEntity.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphScheduleEntity object itself.
     */
    public MicrosoftGraphScheduleEntity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endDateTime",
            this.endDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime));
        jsonWriter.writeStringField("startDateTime",
            this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeStringField("theme", this.theme == null ? null : this.theme.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphScheduleEntity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphScheduleEntity if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphScheduleEntity.
     */
    public static MicrosoftGraphScheduleEntity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphScheduleEntity deserializedMicrosoftGraphScheduleEntity = new MicrosoftGraphScheduleEntity();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleEntity.endDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleEntity.startDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("theme".equals(fieldName)) {
                    deserializedMicrosoftGraphScheduleEntity.theme
                        = MicrosoftGraphScheduleEntityTheme.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphScheduleEntity.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphScheduleEntity;
        });
    }
}
