// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a saml single sign on settings.
 */
@Fluent
public final class MicrosoftGraphSamlSingleSignOnSettings
    implements JsonSerializable<MicrosoftGraphSamlSingleSignOnSettings> {
    /*
     * The relative URI the service provider would redirect to after completion of the single sign-on flow.
     */
    private String relayState;

    /*
     * samlSingleSignOnSettings
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSamlSingleSignOnSettings class.
     */
    public MicrosoftGraphSamlSingleSignOnSettings() {
    }

    /**
     * Get the relayState property: The relative URI the service provider would redirect to after completion of the
     * single sign-on flow.
     * 
     * @return the relayState value.
     */
    public String relayState() {
        return this.relayState;
    }

    /**
     * Set the relayState property: The relative URI the service provider would redirect to after completion of the
     * single sign-on flow.
     * 
     * @param relayState the relayState value to set.
     * @return the MicrosoftGraphSamlSingleSignOnSettings object itself.
     */
    public MicrosoftGraphSamlSingleSignOnSettings withRelayState(String relayState) {
        this.relayState = relayState;
        return this;
    }

    /**
     * Get the additionalProperties property: samlSingleSignOnSettings.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: samlSingleSignOnSettings.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSamlSingleSignOnSettings object itself.
     */
    public MicrosoftGraphSamlSingleSignOnSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("relayState", this.relayState);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSamlSingleSignOnSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSamlSingleSignOnSettings if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSamlSingleSignOnSettings.
     */
    public static MicrosoftGraphSamlSingleSignOnSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSamlSingleSignOnSettings deserializedMicrosoftGraphSamlSingleSignOnSettings
                = new MicrosoftGraphSamlSingleSignOnSettings();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("relayState".equals(fieldName)) {
                    deserializedMicrosoftGraphSamlSingleSignOnSettings.relayState = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSamlSingleSignOnSettings.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSamlSingleSignOnSettings;
        });
    }
}
