// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a profile photo.
 */
@Fluent
public final class MicrosoftGraphProfilePhoto extends MicrosoftGraphEntity {
    /*
     * The height of the photo. Read-only.
     */
    private Integer height;

    /*
     * The width of the photo. Read-only.
     */
    private Integer width;

    /*
     * profilePhoto
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphProfilePhoto class.
     */
    public MicrosoftGraphProfilePhoto() {
    }

    /**
     * Get the height property: The height of the photo. Read-only.
     * 
     * @return the height value.
     */
    public Integer height() {
        return this.height;
    }

    /**
     * Set the height property: The height of the photo. Read-only.
     * 
     * @param height the height value to set.
     * @return the MicrosoftGraphProfilePhoto object itself.
     */
    public MicrosoftGraphProfilePhoto withHeight(Integer height) {
        this.height = height;
        return this;
    }

    /**
     * Get the width property: The width of the photo. Read-only.
     * 
     * @return the width value.
     */
    public Integer width() {
        return this.width;
    }

    /**
     * Set the width property: The width of the photo. Read-only.
     * 
     * @param width the width value to set.
     * @return the MicrosoftGraphProfilePhoto object itself.
     */
    public MicrosoftGraphProfilePhoto withWidth(Integer width) {
        this.width = width;
        return this;
    }

    /**
     * Get the additionalProperties property: profilePhoto.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: profilePhoto.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphProfilePhoto object itself.
     */
    public MicrosoftGraphProfilePhoto withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphProfilePhoto withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeNumberField("height", this.height);
        jsonWriter.writeNumberField("width", this.width);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphProfilePhoto from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphProfilePhoto if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphProfilePhoto.
     */
    public static MicrosoftGraphProfilePhoto fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphProfilePhoto deserializedMicrosoftGraphProfilePhoto = new MicrosoftGraphProfilePhoto();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphProfilePhoto.withId(reader.getString());
                } else if ("height".equals(fieldName)) {
                    deserializedMicrosoftGraphProfilePhoto.height = reader.getNullable(JsonReader::getInt);
                } else if ("width".equals(fieldName)) {
                    deserializedMicrosoftGraphProfilePhoto.width = reader.getNullable(JsonReader::getInt);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphProfilePhoto.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphProfilePhoto;
        });
    }
}
