// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a pre authorized application.
 */
@Fluent
public final class MicrosoftGraphPreAuthorizedApplication
    implements JsonSerializable<MicrosoftGraphPreAuthorizedApplication> {
    /*
     * The unique identifier for the application.
     */
    private String appId;

    /*
     * The unique identifier for the oauth2PermissionScopes the application requires.
     */
    private List<String> delegatedPermissionIds;

    /*
     * preAuthorizedApplication
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPreAuthorizedApplication class.
     */
    public MicrosoftGraphPreAuthorizedApplication() {
    }

    /**
     * Get the appId property: The unique identifier for the application.
     * 
     * @return the appId value.
     */
    public String appId() {
        return this.appId;
    }

    /**
     * Set the appId property: The unique identifier for the application.
     * 
     * @param appId the appId value to set.
     * @return the MicrosoftGraphPreAuthorizedApplication object itself.
     */
    public MicrosoftGraphPreAuthorizedApplication withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    /**
     * Get the delegatedPermissionIds property: The unique identifier for the oauth2PermissionScopes the application
     * requires.
     * 
     * @return the delegatedPermissionIds value.
     */
    public List<String> delegatedPermissionIds() {
        return this.delegatedPermissionIds;
    }

    /**
     * Set the delegatedPermissionIds property: The unique identifier for the oauth2PermissionScopes the application
     * requires.
     * 
     * @param delegatedPermissionIds the delegatedPermissionIds value to set.
     * @return the MicrosoftGraphPreAuthorizedApplication object itself.
     */
    public MicrosoftGraphPreAuthorizedApplication withDelegatedPermissionIds(List<String> delegatedPermissionIds) {
        this.delegatedPermissionIds = delegatedPermissionIds;
        return this;
    }

    /**
     * Get the additionalProperties property: preAuthorizedApplication.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: preAuthorizedApplication.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPreAuthorizedApplication object itself.
     */
    public MicrosoftGraphPreAuthorizedApplication withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appId", this.appId);
        jsonWriter.writeArrayField("delegatedPermissionIds", this.delegatedPermissionIds,
            (writer, element) -> writer.writeString(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPreAuthorizedApplication from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPreAuthorizedApplication if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPreAuthorizedApplication.
     */
    public static MicrosoftGraphPreAuthorizedApplication fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPreAuthorizedApplication deserializedMicrosoftGraphPreAuthorizedApplication
                = new MicrosoftGraphPreAuthorizedApplication();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("appId".equals(fieldName)) {
                    deserializedMicrosoftGraphPreAuthorizedApplication.appId = reader.getString();
                } else if ("delegatedPermissionIds".equals(fieldName)) {
                    List<String> delegatedPermissionIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphPreAuthorizedApplication.delegatedPermissionIds = delegatedPermissionIds;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPreAuthorizedApplication.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPreAuthorizedApplication;
        });
    }
}
