// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a planner user.
 */
@Fluent
public final class MicrosoftGraphPlannerUser extends MicrosoftGraphEntity {
    /*
     * Read-only. Nullable. Returns the plannerTasks assigned to the user.
     */
    private List<MicrosoftGraphPlannerPlan> plans;

    /*
     * Read-only. Nullable. Returns the plannerPlans shared with the user.
     */
    private List<MicrosoftGraphPlannerTask> tasks;

    /*
     * plannerUser
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPlannerUser class.
     */
    public MicrosoftGraphPlannerUser() {
    }

    /**
     * Get the plans property: Read-only. Nullable. Returns the plannerTasks assigned to the user.
     * 
     * @return the plans value.
     */
    public List<MicrosoftGraphPlannerPlan> plans() {
        return this.plans;
    }

    /**
     * Set the plans property: Read-only. Nullable. Returns the plannerTasks assigned to the user.
     * 
     * @param plans the plans value to set.
     * @return the MicrosoftGraphPlannerUser object itself.
     */
    public MicrosoftGraphPlannerUser withPlans(List<MicrosoftGraphPlannerPlan> plans) {
        this.plans = plans;
        return this;
    }

    /**
     * Get the tasks property: Read-only. Nullable. Returns the plannerPlans shared with the user.
     * 
     * @return the tasks value.
     */
    public List<MicrosoftGraphPlannerTask> tasks() {
        return this.tasks;
    }

    /**
     * Set the tasks property: Read-only. Nullable. Returns the plannerPlans shared with the user.
     * 
     * @param tasks the tasks value to set.
     * @return the MicrosoftGraphPlannerUser object itself.
     */
    public MicrosoftGraphPlannerUser withTasks(List<MicrosoftGraphPlannerTask> tasks) {
        this.tasks = tasks;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerUser.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerUser.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerUser object itself.
     */
    public MicrosoftGraphPlannerUser withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPlannerUser withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (plans() != null) {
            plans().forEach(e -> e.validate());
        }
        if (tasks() != null) {
            tasks().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeArrayField("plans", this.plans, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("tasks", this.tasks, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPlannerUser from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPlannerUser if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPlannerUser.
     */
    public static MicrosoftGraphPlannerUser fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPlannerUser deserializedMicrosoftGraphPlannerUser = new MicrosoftGraphPlannerUser();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerUser.withId(reader.getString());
                } else if ("plans".equals(fieldName)) {
                    List<MicrosoftGraphPlannerPlan> plans
                        = reader.readArray(reader1 -> MicrosoftGraphPlannerPlan.fromJson(reader1));
                    deserializedMicrosoftGraphPlannerUser.plans = plans;
                } else if ("tasks".equals(fieldName)) {
                    List<MicrosoftGraphPlannerTask> tasks
                        = reader.readArray(reader1 -> MicrosoftGraphPlannerTask.fromJson(reader1));
                    deserializedMicrosoftGraphPlannerUser.tasks = tasks;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPlannerUser.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPlannerUser;
        });
    }
}
