// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a planner task.
 */
@Fluent
public final class MicrosoftGraphPlannerTask extends MicrosoftGraphEntity {
    /*
     * Number of checklist items with value set to false, representing incomplete items.
     */
    private Integer activeChecklistItemCount;

    /*
     * plannerAppliedCategories
     */
    private Map<String, Object> appliedCategories;

    /*
     * Hint used to order items of this type in a list view. The format is defined as outlined here.
     */
    private String assigneePriority;

    /*
     * plannerAssignments
     */
    private Map<String, Object> assignments;

    /*
     * Bucket ID to which the task belongs. The bucket needs to be in the plan that the task is in. It is 28 characters
     * long and case-sensitive. Format validation is done on the service.
     */
    private String bucketId;

    /*
     * Number of checklist items that are present on the task.
     */
    private Integer checklistItemCount;

    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet completedBy;

    /*
     * Read-only. Date and time at which the 'percentComplete' of the task is set to '100'. The Timestamp type
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    private OffsetDateTime completedDateTime;

    /*
     * Thread ID of the conversation on the task. This is the ID of the conversation thread object created in the group.
     */
    private String conversationThreadId;

    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet createdBy;

    /*
     * Read-only. Date and time at which the task is created. The Timestamp type represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'
     */
    private OffsetDateTime createdDateTime;

    /*
     * Date and time at which the task is due. The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'
     */
    private OffsetDateTime dueDateTime;

    /*
     * Read-only. Value is true if the details object of the task has a non-empty description and false otherwise.
     */
    private Boolean hasDescription;

    /*
     * Hint used to order items of this type in a list view. The format is defined as outlined here.
     */
    private String orderHint;

    /*
     * Percentage of task completion. When set to 100, the task is considered completed.
     */
    private Integer percentComplete;

    /*
     * Plan ID to which the task belongs.
     */
    private String planId;

    /*
     * plannerPreviewType
     */
    private MicrosoftGraphPlannerPreviewType previewType;

    /*
     * Number of external references that exist on the task.
     */
    private Integer referenceCount;

    /*
     * Date and time at which the task starts. The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'
     */
    private OffsetDateTime startDateTime;

    /*
     * Title of the task.
     */
    private String title;

    /*
     * plannerAssignedToTaskBoardTaskFormat
     */
    private MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat assignedToTaskBoardFormat;

    /*
     * plannerBucketTaskBoardTaskFormat
     */
    private MicrosoftGraphPlannerBucketTaskBoardTaskFormat bucketTaskBoardFormat;

    /*
     * plannerTaskDetails
     */
    private MicrosoftGraphPlannerTaskDetails details;

    /*
     * plannerProgressTaskBoardTaskFormat
     */
    private MicrosoftGraphPlannerProgressTaskBoardTaskFormat progressTaskBoardFormat;

    /*
     * plannerTask
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPlannerTask class.
     */
    public MicrosoftGraphPlannerTask() {
    }

    /**
     * Get the activeChecklistItemCount property: Number of checklist items with value set to false, representing
     * incomplete items.
     * 
     * @return the activeChecklistItemCount value.
     */
    public Integer activeChecklistItemCount() {
        return this.activeChecklistItemCount;
    }

    /**
     * Set the activeChecklistItemCount property: Number of checklist items with value set to false, representing
     * incomplete items.
     * 
     * @param activeChecklistItemCount the activeChecklistItemCount value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withActiveChecklistItemCount(Integer activeChecklistItemCount) {
        this.activeChecklistItemCount = activeChecklistItemCount;
        return this;
    }

    /**
     * Get the appliedCategories property: plannerAppliedCategories.
     * 
     * @return the appliedCategories value.
     */
    public Map<String, Object> appliedCategories() {
        return this.appliedCategories;
    }

    /**
     * Set the appliedCategories property: plannerAppliedCategories.
     * 
     * @param appliedCategories the appliedCategories value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withAppliedCategories(Map<String, Object> appliedCategories) {
        this.appliedCategories = appliedCategories;
        return this;
    }

    /**
     * Get the assigneePriority property: Hint used to order items of this type in a list view. The format is defined as
     * outlined here.
     * 
     * @return the assigneePriority value.
     */
    public String assigneePriority() {
        return this.assigneePriority;
    }

    /**
     * Set the assigneePriority property: Hint used to order items of this type in a list view. The format is defined as
     * outlined here.
     * 
     * @param assigneePriority the assigneePriority value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withAssigneePriority(String assigneePriority) {
        this.assigneePriority = assigneePriority;
        return this;
    }

    /**
     * Get the assignments property: plannerAssignments.
     * 
     * @return the assignments value.
     */
    public Map<String, Object> assignments() {
        return this.assignments;
    }

    /**
     * Set the assignments property: plannerAssignments.
     * 
     * @param assignments the assignments value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withAssignments(Map<String, Object> assignments) {
        this.assignments = assignments;
        return this;
    }

    /**
     * Get the bucketId property: Bucket ID to which the task belongs. The bucket needs to be in the plan that the task
     * is in. It is 28 characters long and case-sensitive. Format validation is done on the service.
     * 
     * @return the bucketId value.
     */
    public String bucketId() {
        return this.bucketId;
    }

    /**
     * Set the bucketId property: Bucket ID to which the task belongs. The bucket needs to be in the plan that the task
     * is in. It is 28 characters long and case-sensitive. Format validation is done on the service.
     * 
     * @param bucketId the bucketId value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withBucketId(String bucketId) {
        this.bucketId = bucketId;
        return this;
    }

    /**
     * Get the checklistItemCount property: Number of checklist items that are present on the task.
     * 
     * @return the checklistItemCount value.
     */
    public Integer checklistItemCount() {
        return this.checklistItemCount;
    }

    /**
     * Set the checklistItemCount property: Number of checklist items that are present on the task.
     * 
     * @param checklistItemCount the checklistItemCount value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withChecklistItemCount(Integer checklistItemCount) {
        this.checklistItemCount = checklistItemCount;
        return this;
    }

    /**
     * Get the completedBy property: identitySet.
     * 
     * @return the completedBy value.
     */
    public MicrosoftGraphIdentitySet completedBy() {
        return this.completedBy;
    }

    /**
     * Set the completedBy property: identitySet.
     * 
     * @param completedBy the completedBy value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withCompletedBy(MicrosoftGraphIdentitySet completedBy) {
        this.completedBy = completedBy;
        return this;
    }

    /**
     * Get the completedDateTime property: Read-only. Date and time at which the 'percentComplete' of the task is set to
     * '100'. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time.
     * For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @return the completedDateTime value.
     */
    public OffsetDateTime completedDateTime() {
        return this.completedDateTime;
    }

    /**
     * Set the completedDateTime property: Read-only. Date and time at which the 'percentComplete' of the task is set to
     * '100'. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time.
     * For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @param completedDateTime the completedDateTime value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withCompletedDateTime(OffsetDateTime completedDateTime) {
        this.completedDateTime = completedDateTime;
        return this;
    }

    /**
     * Get the conversationThreadId property: Thread ID of the conversation on the task. This is the ID of the
     * conversation thread object created in the group.
     * 
     * @return the conversationThreadId value.
     */
    public String conversationThreadId() {
        return this.conversationThreadId;
    }

    /**
     * Set the conversationThreadId property: Thread ID of the conversation on the task. This is the ID of the
     * conversation thread object created in the group.
     * 
     * @param conversationThreadId the conversationThreadId value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withConversationThreadId(String conversationThreadId) {
        this.conversationThreadId = conversationThreadId;
        return this;
    }

    /**
     * Get the createdBy property: identitySet.
     * 
     * @return the createdBy value.
     */
    public MicrosoftGraphIdentitySet createdBy() {
        return this.createdBy;
    }

    /**
     * Set the createdBy property: identitySet.
     * 
     * @param createdBy the createdBy value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * Get the createdDateTime property: Read-only. Date and time at which the task is created. The Timestamp type
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Read-only. Date and time at which the task is created. The Timestamp type
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the dueDateTime property: Date and time at which the task is due. The Timestamp type represents date and time
     * information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look
     * like this: '2014-01-01T00:00:00Z'.
     * 
     * @return the dueDateTime value.
     */
    public OffsetDateTime dueDateTime() {
        return this.dueDateTime;
    }

    /**
     * Set the dueDateTime property: Date and time at which the task is due. The Timestamp type represents date and time
     * information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look
     * like this: '2014-01-01T00:00:00Z'.
     * 
     * @param dueDateTime the dueDateTime value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withDueDateTime(OffsetDateTime dueDateTime) {
        this.dueDateTime = dueDateTime;
        return this;
    }

    /**
     * Get the hasDescription property: Read-only. Value is true if the details object of the task has a non-empty
     * description and false otherwise.
     * 
     * @return the hasDescription value.
     */
    public Boolean hasDescription() {
        return this.hasDescription;
    }

    /**
     * Set the hasDescription property: Read-only. Value is true if the details object of the task has a non-empty
     * description and false otherwise.
     * 
     * @param hasDescription the hasDescription value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withHasDescription(Boolean hasDescription) {
        this.hasDescription = hasDescription;
        return this;
    }

    /**
     * Get the orderHint property: Hint used to order items of this type in a list view. The format is defined as
     * outlined here.
     * 
     * @return the orderHint value.
     */
    public String orderHint() {
        return this.orderHint;
    }

    /**
     * Set the orderHint property: Hint used to order items of this type in a list view. The format is defined as
     * outlined here.
     * 
     * @param orderHint the orderHint value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withOrderHint(String orderHint) {
        this.orderHint = orderHint;
        return this;
    }

    /**
     * Get the percentComplete property: Percentage of task completion. When set to 100, the task is considered
     * completed.
     * 
     * @return the percentComplete value.
     */
    public Integer percentComplete() {
        return this.percentComplete;
    }

    /**
     * Set the percentComplete property: Percentage of task completion. When set to 100, the task is considered
     * completed.
     * 
     * @param percentComplete the percentComplete value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withPercentComplete(Integer percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    /**
     * Get the planId property: Plan ID to which the task belongs.
     * 
     * @return the planId value.
     */
    public String planId() {
        return this.planId;
    }

    /**
     * Set the planId property: Plan ID to which the task belongs.
     * 
     * @param planId the planId value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withPlanId(String planId) {
        this.planId = planId;
        return this;
    }

    /**
     * Get the previewType property: plannerPreviewType.
     * 
     * @return the previewType value.
     */
    public MicrosoftGraphPlannerPreviewType previewType() {
        return this.previewType;
    }

    /**
     * Set the previewType property: plannerPreviewType.
     * 
     * @param previewType the previewType value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withPreviewType(MicrosoftGraphPlannerPreviewType previewType) {
        this.previewType = previewType;
        return this;
    }

    /**
     * Get the referenceCount property: Number of external references that exist on the task.
     * 
     * @return the referenceCount value.
     */
    public Integer referenceCount() {
        return this.referenceCount;
    }

    /**
     * Set the referenceCount property: Number of external references that exist on the task.
     * 
     * @param referenceCount the referenceCount value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withReferenceCount(Integer referenceCount) {
        this.referenceCount = referenceCount;
        return this;
    }

    /**
     * Get the startDateTime property: Date and time at which the task starts. The Timestamp type represents date and
     * time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would
     * look like this: '2014-01-01T00:00:00Z'.
     * 
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: Date and time at which the task starts. The Timestamp type represents date and
     * time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would
     * look like this: '2014-01-01T00:00:00Z'.
     * 
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the title property: Title of the task.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: Title of the task.
     * 
     * @param title the title value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the assignedToTaskBoardFormat property: plannerAssignedToTaskBoardTaskFormat.
     * 
     * @return the assignedToTaskBoardFormat value.
     */
    public MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat assignedToTaskBoardFormat() {
        return this.assignedToTaskBoardFormat;
    }

    /**
     * Set the assignedToTaskBoardFormat property: plannerAssignedToTaskBoardTaskFormat.
     * 
     * @param assignedToTaskBoardFormat the assignedToTaskBoardFormat value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask
        withAssignedToTaskBoardFormat(MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat assignedToTaskBoardFormat) {
        this.assignedToTaskBoardFormat = assignedToTaskBoardFormat;
        return this;
    }

    /**
     * Get the bucketTaskBoardFormat property: plannerBucketTaskBoardTaskFormat.
     * 
     * @return the bucketTaskBoardFormat value.
     */
    public MicrosoftGraphPlannerBucketTaskBoardTaskFormat bucketTaskBoardFormat() {
        return this.bucketTaskBoardFormat;
    }

    /**
     * Set the bucketTaskBoardFormat property: plannerBucketTaskBoardTaskFormat.
     * 
     * @param bucketTaskBoardFormat the bucketTaskBoardFormat value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask
        withBucketTaskBoardFormat(MicrosoftGraphPlannerBucketTaskBoardTaskFormat bucketTaskBoardFormat) {
        this.bucketTaskBoardFormat = bucketTaskBoardFormat;
        return this;
    }

    /**
     * Get the details property: plannerTaskDetails.
     * 
     * @return the details value.
     */
    public MicrosoftGraphPlannerTaskDetails details() {
        return this.details;
    }

    /**
     * Set the details property: plannerTaskDetails.
     * 
     * @param details the details value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withDetails(MicrosoftGraphPlannerTaskDetails details) {
        this.details = details;
        return this;
    }

    /**
     * Get the progressTaskBoardFormat property: plannerProgressTaskBoardTaskFormat.
     * 
     * @return the progressTaskBoardFormat value.
     */
    public MicrosoftGraphPlannerProgressTaskBoardTaskFormat progressTaskBoardFormat() {
        return this.progressTaskBoardFormat;
    }

    /**
     * Set the progressTaskBoardFormat property: plannerProgressTaskBoardTaskFormat.
     * 
     * @param progressTaskBoardFormat the progressTaskBoardFormat value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask
        withProgressTaskBoardFormat(MicrosoftGraphPlannerProgressTaskBoardTaskFormat progressTaskBoardFormat) {
        this.progressTaskBoardFormat = progressTaskBoardFormat;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerTask.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerTask.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerTask object itself.
     */
    public MicrosoftGraphPlannerTask withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPlannerTask withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (completedBy() != null) {
            completedBy().validate();
        }
        if (createdBy() != null) {
            createdBy().validate();
        }
        if (assignedToTaskBoardFormat() != null) {
            assignedToTaskBoardFormat().validate();
        }
        if (bucketTaskBoardFormat() != null) {
            bucketTaskBoardFormat().validate();
        }
        if (details() != null) {
            details().validate();
        }
        if (progressTaskBoardFormat() != null) {
            progressTaskBoardFormat().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeNumberField("activeChecklistItemCount", this.activeChecklistItemCount);
        jsonWriter.writeMapField("appliedCategories", this.appliedCategories,
            (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("assigneePriority", this.assigneePriority);
        jsonWriter.writeMapField("assignments", this.assignments, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("bucketId", this.bucketId);
        jsonWriter.writeNumberField("checklistItemCount", this.checklistItemCount);
        jsonWriter.writeJsonField("completedBy", this.completedBy);
        jsonWriter.writeStringField("completedDateTime",
            this.completedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.completedDateTime));
        jsonWriter.writeStringField("conversationThreadId", this.conversationThreadId);
        jsonWriter.writeJsonField("createdBy", this.createdBy);
        jsonWriter.writeStringField("createdDateTime",
            this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("dueDateTime",
            this.dueDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.dueDateTime));
        jsonWriter.writeBooleanField("hasDescription", this.hasDescription);
        jsonWriter.writeStringField("orderHint", this.orderHint);
        jsonWriter.writeNumberField("percentComplete", this.percentComplete);
        jsonWriter.writeStringField("planId", this.planId);
        jsonWriter.writeStringField("previewType", this.previewType == null ? null : this.previewType.toString());
        jsonWriter.writeNumberField("referenceCount", this.referenceCount);
        jsonWriter.writeStringField("startDateTime",
            this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeJsonField("assignedToTaskBoardFormat", this.assignedToTaskBoardFormat);
        jsonWriter.writeJsonField("bucketTaskBoardFormat", this.bucketTaskBoardFormat);
        jsonWriter.writeJsonField("details", this.details);
        jsonWriter.writeJsonField("progressTaskBoardFormat", this.progressTaskBoardFormat);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPlannerTask from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPlannerTask if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPlannerTask.
     */
    public static MicrosoftGraphPlannerTask fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPlannerTask deserializedMicrosoftGraphPlannerTask = new MicrosoftGraphPlannerTask();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.withId(reader.getString());
                } else if ("activeChecklistItemCount".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.activeChecklistItemCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("appliedCategories".equals(fieldName)) {
                    Map<String, Object> appliedCategories = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphPlannerTask.appliedCategories = appliedCategories;
                } else if ("assigneePriority".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.assigneePriority = reader.getString();
                } else if ("assignments".equals(fieldName)) {
                    Map<String, Object> assignments = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphPlannerTask.assignments = assignments;
                } else if ("bucketId".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.bucketId = reader.getString();
                } else if ("checklistItemCount".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.checklistItemCount = reader.getNullable(JsonReader::getInt);
                } else if ("completedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.completedBy = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("completedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.completedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("conversationThreadId".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.conversationThreadId = reader.getString();
                } else if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.createdBy = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("dueDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.dueDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("hasDescription".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.hasDescription = reader.getNullable(JsonReader::getBoolean);
                } else if ("orderHint".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.orderHint = reader.getString();
                } else if ("percentComplete".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.percentComplete = reader.getNullable(JsonReader::getInt);
                } else if ("planId".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.planId = reader.getString();
                } else if ("previewType".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.previewType
                        = MicrosoftGraphPlannerPreviewType.fromString(reader.getString());
                } else if ("referenceCount".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.referenceCount = reader.getNullable(JsonReader::getInt);
                } else if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.startDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("title".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.title = reader.getString();
                } else if ("assignedToTaskBoardFormat".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.assignedToTaskBoardFormat
                        = MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat.fromJson(reader);
                } else if ("bucketTaskBoardFormat".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.bucketTaskBoardFormat
                        = MicrosoftGraphPlannerBucketTaskBoardTaskFormat.fromJson(reader);
                } else if ("details".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.details = MicrosoftGraphPlannerTaskDetails.fromJson(reader);
                } else if ("progressTaskBoardFormat".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerTask.progressTaskBoardFormat
                        = MicrosoftGraphPlannerProgressTaskBoardTaskFormat.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPlannerTask.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPlannerTask;
        });
    }
}
