// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a planner progress task board task format.
 */
@Fluent
public final class MicrosoftGraphPlannerProgressTaskBoardTaskFormat extends MicrosoftGraphEntity {
    /*
     * Hint value used to order the task on the Progress view of the Task Board. The format is defined as outlined here.
     */
    private String orderHint;

    /*
     * plannerProgressTaskBoardTaskFormat
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPlannerProgressTaskBoardTaskFormat class.
     */
    public MicrosoftGraphPlannerProgressTaskBoardTaskFormat() {
    }

    /**
     * Get the orderHint property: Hint value used to order the task on the Progress view of the Task Board. The format
     * is defined as outlined here.
     * 
     * @return the orderHint value.
     */
    public String orderHint() {
        return this.orderHint;
    }

    /**
     * Set the orderHint property: Hint value used to order the task on the Progress view of the Task Board. The format
     * is defined as outlined here.
     * 
     * @param orderHint the orderHint value to set.
     * @return the MicrosoftGraphPlannerProgressTaskBoardTaskFormat object itself.
     */
    public MicrosoftGraphPlannerProgressTaskBoardTaskFormat withOrderHint(String orderHint) {
        this.orderHint = orderHint;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerProgressTaskBoardTaskFormat.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerProgressTaskBoardTaskFormat.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerProgressTaskBoardTaskFormat object itself.
     */
    public MicrosoftGraphPlannerProgressTaskBoardTaskFormat
        withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPlannerProgressTaskBoardTaskFormat withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("orderHint", this.orderHint);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPlannerProgressTaskBoardTaskFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPlannerProgressTaskBoardTaskFormat if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPlannerProgressTaskBoardTaskFormat.
     */
    public static MicrosoftGraphPlannerProgressTaskBoardTaskFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPlannerProgressTaskBoardTaskFormat deserializedMicrosoftGraphPlannerProgressTaskBoardTaskFormat
                = new MicrosoftGraphPlannerProgressTaskBoardTaskFormat();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerProgressTaskBoardTaskFormat.withId(reader.getString());
                } else if ("orderHint".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerProgressTaskBoardTaskFormat.orderHint = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPlannerProgressTaskBoardTaskFormat.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPlannerProgressTaskBoardTaskFormat;
        });
    }
}
