// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a planner plan.
 */
@Fluent
public final class MicrosoftGraphPlannerPlan extends MicrosoftGraphEntity {
    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet createdBy;

    /*
     * Read-only. Date and time at which the plan is created. The Timestamp type represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'
     */
    private OffsetDateTime createdDateTime;

    /*
     * ID of the Group that owns the plan. A valid group must exist before this field can be set. After it is set, this
     * property can’t be updated.
     */
    private String owner;

    /*
     * Required. Title of the plan.
     */
    private String title;

    /*
     * Read-only. Nullable. Collection of buckets in the plan.
     */
    private List<MicrosoftGraphPlannerBucket> buckets;

    /*
     * plannerPlanDetails
     */
    private MicrosoftGraphPlannerPlanDetails details;

    /*
     * Read-only. Nullable. Collection of tasks in the plan.
     */
    private List<MicrosoftGraphPlannerTask> tasks;

    /*
     * plannerPlan
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPlannerPlan class.
     */
    public MicrosoftGraphPlannerPlan() {
    }

    /**
     * Get the createdBy property: identitySet.
     * 
     * @return the createdBy value.
     */
    public MicrosoftGraphIdentitySet createdBy() {
        return this.createdBy;
    }

    /**
     * Set the createdBy property: identitySet.
     * 
     * @param createdBy the createdBy value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * Get the createdDateTime property: Read-only. Date and time at which the plan is created. The Timestamp type
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Read-only. Date and time at which the plan is created. The Timestamp type
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the owner property: ID of the Group that owns the plan. A valid group must exist before this field can be
     * set. After it is set, this property can’t be updated.
     * 
     * @return the owner value.
     */
    public String owner() {
        return this.owner;
    }

    /**
     * Set the owner property: ID of the Group that owns the plan. A valid group must exist before this field can be
     * set. After it is set, this property can’t be updated.
     * 
     * @param owner the owner value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    /**
     * Get the title property: Required. Title of the plan.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: Required. Title of the plan.
     * 
     * @param title the title value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the buckets property: Read-only. Nullable. Collection of buckets in the plan.
     * 
     * @return the buckets value.
     */
    public List<MicrosoftGraphPlannerBucket> buckets() {
        return this.buckets;
    }

    /**
     * Set the buckets property: Read-only. Nullable. Collection of buckets in the plan.
     * 
     * @param buckets the buckets value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withBuckets(List<MicrosoftGraphPlannerBucket> buckets) {
        this.buckets = buckets;
        return this;
    }

    /**
     * Get the details property: plannerPlanDetails.
     * 
     * @return the details value.
     */
    public MicrosoftGraphPlannerPlanDetails details() {
        return this.details;
    }

    /**
     * Set the details property: plannerPlanDetails.
     * 
     * @param details the details value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withDetails(MicrosoftGraphPlannerPlanDetails details) {
        this.details = details;
        return this;
    }

    /**
     * Get the tasks property: Read-only. Nullable. Collection of tasks in the plan.
     * 
     * @return the tasks value.
     */
    public List<MicrosoftGraphPlannerTask> tasks() {
        return this.tasks;
    }

    /**
     * Set the tasks property: Read-only. Nullable. Collection of tasks in the plan.
     * 
     * @param tasks the tasks value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withTasks(List<MicrosoftGraphPlannerTask> tasks) {
        this.tasks = tasks;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerPlan.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerPlan.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerPlan object itself.
     */
    public MicrosoftGraphPlannerPlan withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPlannerPlan withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (createdBy() != null) {
            createdBy().validate();
        }
        if (buckets() != null) {
            buckets().forEach(e -> e.validate());
        }
        if (details() != null) {
            details().validate();
        }
        if (tasks() != null) {
            tasks().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("createdBy", this.createdBy);
        jsonWriter.writeStringField("createdDateTime",
            this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("owner", this.owner);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeArrayField("buckets", this.buckets, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("details", this.details);
        jsonWriter.writeArrayField("tasks", this.tasks, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPlannerPlan from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPlannerPlan if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPlannerPlan.
     */
    public static MicrosoftGraphPlannerPlan fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPlannerPlan deserializedMicrosoftGraphPlannerPlan = new MicrosoftGraphPlannerPlan();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlan.withId(reader.getString());
                } else if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlan.createdBy = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlan.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("owner".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlan.owner = reader.getString();
                } else if ("title".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlan.title = reader.getString();
                } else if ("buckets".equals(fieldName)) {
                    List<MicrosoftGraphPlannerBucket> buckets
                        = reader.readArray(reader1 -> MicrosoftGraphPlannerBucket.fromJson(reader1));
                    deserializedMicrosoftGraphPlannerPlan.buckets = buckets;
                } else if ("details".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlan.details = MicrosoftGraphPlannerPlanDetails.fromJson(reader);
                } else if ("tasks".equals(fieldName)) {
                    List<MicrosoftGraphPlannerTask> tasks
                        = reader.readArray(reader1 -> MicrosoftGraphPlannerTask.fromJson(reader1));
                    deserializedMicrosoftGraphPlannerPlan.tasks = tasks;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPlannerPlan.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPlannerPlan;
        });
    }
}
