// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a planner group.
 */
@Fluent
public final class MicrosoftGraphPlannerGroup extends MicrosoftGraphEntity {
    /*
     * Read-only. Nullable. Returns the plannerPlans owned by the group.
     */
    private List<MicrosoftGraphPlannerPlan> plans;

    /*
     * plannerGroup
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPlannerGroup class.
     */
    public MicrosoftGraphPlannerGroup() {
    }

    /**
     * Get the plans property: Read-only. Nullable. Returns the plannerPlans owned by the group.
     * 
     * @return the plans value.
     */
    public List<MicrosoftGraphPlannerPlan> plans() {
        return this.plans;
    }

    /**
     * Set the plans property: Read-only. Nullable. Returns the plannerPlans owned by the group.
     * 
     * @param plans the plans value to set.
     * @return the MicrosoftGraphPlannerGroup object itself.
     */
    public MicrosoftGraphPlannerGroup withPlans(List<MicrosoftGraphPlannerPlan> plans) {
        this.plans = plans;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerGroup.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerGroup.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerGroup object itself.
     */
    public MicrosoftGraphPlannerGroup withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPlannerGroup withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (plans() != null) {
            plans().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeArrayField("plans", this.plans, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPlannerGroup from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPlannerGroup if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPlannerGroup.
     */
    public static MicrosoftGraphPlannerGroup fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPlannerGroup deserializedMicrosoftGraphPlannerGroup = new MicrosoftGraphPlannerGroup();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerGroup.withId(reader.getString());
                } else if ("plans".equals(fieldName)) {
                    List<MicrosoftGraphPlannerPlan> plans
                        = reader.readArray(reader1 -> MicrosoftGraphPlannerPlan.fromJson(reader1));
                    deserializedMicrosoftGraphPlannerGroup.plans = plans;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPlannerGroup.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPlannerGroup;
        });
    }
}
