// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a planner bucket task board task format.
 */
@Fluent
public final class MicrosoftGraphPlannerBucketTaskBoardTaskFormat extends MicrosoftGraphEntity {
    /*
     * Hint used to order tasks in the Bucket view of the Task Board. The format is defined as outlined here.
     */
    private String orderHint;

    /*
     * plannerBucketTaskBoardTaskFormat
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPlannerBucketTaskBoardTaskFormat class.
     */
    public MicrosoftGraphPlannerBucketTaskBoardTaskFormat() {
    }

    /**
     * Get the orderHint property: Hint used to order tasks in the Bucket view of the Task Board. The format is defined
     * as outlined here.
     * 
     * @return the orderHint value.
     */
    public String orderHint() {
        return this.orderHint;
    }

    /**
     * Set the orderHint property: Hint used to order tasks in the Bucket view of the Task Board. The format is defined
     * as outlined here.
     * 
     * @param orderHint the orderHint value to set.
     * @return the MicrosoftGraphPlannerBucketTaskBoardTaskFormat object itself.
     */
    public MicrosoftGraphPlannerBucketTaskBoardTaskFormat withOrderHint(String orderHint) {
        this.orderHint = orderHint;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerBucketTaskBoardTaskFormat.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerBucketTaskBoardTaskFormat.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerBucketTaskBoardTaskFormat object itself.
     */
    public MicrosoftGraphPlannerBucketTaskBoardTaskFormat
        withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPlannerBucketTaskBoardTaskFormat withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("orderHint", this.orderHint);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPlannerBucketTaskBoardTaskFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPlannerBucketTaskBoardTaskFormat if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPlannerBucketTaskBoardTaskFormat.
     */
    public static MicrosoftGraphPlannerBucketTaskBoardTaskFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPlannerBucketTaskBoardTaskFormat deserializedMicrosoftGraphPlannerBucketTaskBoardTaskFormat
                = new MicrosoftGraphPlannerBucketTaskBoardTaskFormat();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerBucketTaskBoardTaskFormat.withId(reader.getString());
                } else if ("orderHint".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerBucketTaskBoardTaskFormat.orderHint = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPlannerBucketTaskBoardTaskFormat.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPlannerBucketTaskBoardTaskFormat;
        });
    }
}
