// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a physical office address.
 */
@Fluent
public final class MicrosoftGraphPhysicalOfficeAddress
    implements JsonSerializable<MicrosoftGraphPhysicalOfficeAddress> {
    /*
     * The city.
     */
    private String city;

    /*
     * The country or region. It's a free-format string value, for example, 'United States'.
     */
    private String countryOrRegion;

    /*
     * Office location such as building and office number for an organizational contact.
     */
    private String officeLocation;

    /*
     * The postal code.
     */
    private String postalCode;

    /*
     * The state.
     */
    private String state;

    /*
     * The street.
     */
    private String street;

    /*
     * physicalOfficeAddress
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPhysicalOfficeAddress class.
     */
    public MicrosoftGraphPhysicalOfficeAddress() {
    }

    /**
     * Get the city property: The city.
     * 
     * @return the city value.
     */
    public String city() {
        return this.city;
    }

    /**
     * Set the city property: The city.
     * 
     * @param city the city value to set.
     * @return the MicrosoftGraphPhysicalOfficeAddress object itself.
     */
    public MicrosoftGraphPhysicalOfficeAddress withCity(String city) {
        this.city = city;
        return this;
    }

    /**
     * Get the countryOrRegion property: The country or region. It's a free-format string value, for example, 'United
     * States'.
     * 
     * @return the countryOrRegion value.
     */
    public String countryOrRegion() {
        return this.countryOrRegion;
    }

    /**
     * Set the countryOrRegion property: The country or region. It's a free-format string value, for example, 'United
     * States'.
     * 
     * @param countryOrRegion the countryOrRegion value to set.
     * @return the MicrosoftGraphPhysicalOfficeAddress object itself.
     */
    public MicrosoftGraphPhysicalOfficeAddress withCountryOrRegion(String countryOrRegion) {
        this.countryOrRegion = countryOrRegion;
        return this;
    }

    /**
     * Get the officeLocation property: Office location such as building and office number for an organizational
     * contact.
     * 
     * @return the officeLocation value.
     */
    public String officeLocation() {
        return this.officeLocation;
    }

    /**
     * Set the officeLocation property: Office location such as building and office number for an organizational
     * contact.
     * 
     * @param officeLocation the officeLocation value to set.
     * @return the MicrosoftGraphPhysicalOfficeAddress object itself.
     */
    public MicrosoftGraphPhysicalOfficeAddress withOfficeLocation(String officeLocation) {
        this.officeLocation = officeLocation;
        return this;
    }

    /**
     * Get the postalCode property: The postal code.
     * 
     * @return the postalCode value.
     */
    public String postalCode() {
        return this.postalCode;
    }

    /**
     * Set the postalCode property: The postal code.
     * 
     * @param postalCode the postalCode value to set.
     * @return the MicrosoftGraphPhysicalOfficeAddress object itself.
     */
    public MicrosoftGraphPhysicalOfficeAddress withPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    /**
     * Get the state property: The state.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state property: The state.
     * 
     * @param state the state value to set.
     * @return the MicrosoftGraphPhysicalOfficeAddress object itself.
     */
    public MicrosoftGraphPhysicalOfficeAddress withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Get the street property: The street.
     * 
     * @return the street value.
     */
    public String street() {
        return this.street;
    }

    /**
     * Set the street property: The street.
     * 
     * @param street the street value to set.
     * @return the MicrosoftGraphPhysicalOfficeAddress object itself.
     */
    public MicrosoftGraphPhysicalOfficeAddress withStreet(String street) {
        this.street = street;
        return this;
    }

    /**
     * Get the additionalProperties property: physicalOfficeAddress.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: physicalOfficeAddress.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPhysicalOfficeAddress object itself.
     */
    public MicrosoftGraphPhysicalOfficeAddress withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("city", this.city);
        jsonWriter.writeStringField("countryOrRegion", this.countryOrRegion);
        jsonWriter.writeStringField("officeLocation", this.officeLocation);
        jsonWriter.writeStringField("postalCode", this.postalCode);
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeStringField("street", this.street);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPhysicalOfficeAddress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPhysicalOfficeAddress if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPhysicalOfficeAddress.
     */
    public static MicrosoftGraphPhysicalOfficeAddress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPhysicalOfficeAddress deserializedMicrosoftGraphPhysicalOfficeAddress
                = new MicrosoftGraphPhysicalOfficeAddress();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("city".equals(fieldName)) {
                    deserializedMicrosoftGraphPhysicalOfficeAddress.city = reader.getString();
                } else if ("countryOrRegion".equals(fieldName)) {
                    deserializedMicrosoftGraphPhysicalOfficeAddress.countryOrRegion = reader.getString();
                } else if ("officeLocation".equals(fieldName)) {
                    deserializedMicrosoftGraphPhysicalOfficeAddress.officeLocation = reader.getString();
                } else if ("postalCode".equals(fieldName)) {
                    deserializedMicrosoftGraphPhysicalOfficeAddress.postalCode = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedMicrosoftGraphPhysicalOfficeAddress.state = reader.getString();
                } else if ("street".equals(fieldName)) {
                    deserializedMicrosoftGraphPhysicalOfficeAddress.street = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPhysicalOfficeAddress.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPhysicalOfficeAddress;
        });
    }
}
