// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a photo.
 */
@Fluent
public final class MicrosoftGraphPhoto implements JsonSerializable<MicrosoftGraphPhoto> {
    /*
     * Camera manufacturer. Read-only.
     */
    private String cameraMake;

    /*
     * Camera model. Read-only.
     */
    private String cameraModel;

    /*
     * The denominator for the exposure time fraction from the camera. Read-only.
     */
    private Double exposureDenominator;

    /*
     * The numerator for the exposure time fraction from the camera. Read-only.
     */
    private Double exposureNumerator;

    /*
     * The F-stop value from the camera. Read-only.
     */
    private Double fNumber;

    /*
     * The focal length from the camera. Read-only.
     */
    private Double focalLength;

    /*
     * The ISO value from the camera. Read-only.
     */
    private Integer iso;

    /*
     * The orientation value from the camera. Writable on OneDrive Personal.
     */
    private Integer orientation;

    /*
     * Represents the date and time the photo was taken. Read-only.
     */
    private OffsetDateTime takenDateTime;

    /*
     * photo
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPhoto class.
     */
    public MicrosoftGraphPhoto() {
    }

    /**
     * Get the cameraMake property: Camera manufacturer. Read-only.
     * 
     * @return the cameraMake value.
     */
    public String cameraMake() {
        return this.cameraMake;
    }

    /**
     * Set the cameraMake property: Camera manufacturer. Read-only.
     * 
     * @param cameraMake the cameraMake value to set.
     * @return the MicrosoftGraphPhoto object itself.
     */
    public MicrosoftGraphPhoto withCameraMake(String cameraMake) {
        this.cameraMake = cameraMake;
        return this;
    }

    /**
     * Get the cameraModel property: Camera model. Read-only.
     * 
     * @return the cameraModel value.
     */
    public String cameraModel() {
        return this.cameraModel;
    }

    /**
     * Set the cameraModel property: Camera model. Read-only.
     * 
     * @param cameraModel the cameraModel value to set.
     * @return the MicrosoftGraphPhoto object itself.
     */
    public MicrosoftGraphPhoto withCameraModel(String cameraModel) {
        this.cameraModel = cameraModel;
        return this;
    }

    /**
     * Get the exposureDenominator property: The denominator for the exposure time fraction from the camera. Read-only.
     * 
     * @return the exposureDenominator value.
     */
    public Double exposureDenominator() {
        return this.exposureDenominator;
    }

    /**
     * Set the exposureDenominator property: The denominator for the exposure time fraction from the camera. Read-only.
     * 
     * @param exposureDenominator the exposureDenominator value to set.
     * @return the MicrosoftGraphPhoto object itself.
     */
    public MicrosoftGraphPhoto withExposureDenominator(Double exposureDenominator) {
        this.exposureDenominator = exposureDenominator;
        return this;
    }

    /**
     * Get the exposureNumerator property: The numerator for the exposure time fraction from the camera. Read-only.
     * 
     * @return the exposureNumerator value.
     */
    public Double exposureNumerator() {
        return this.exposureNumerator;
    }

    /**
     * Set the exposureNumerator property: The numerator for the exposure time fraction from the camera. Read-only.
     * 
     * @param exposureNumerator the exposureNumerator value to set.
     * @return the MicrosoftGraphPhoto object itself.
     */
    public MicrosoftGraphPhoto withExposureNumerator(Double exposureNumerator) {
        this.exposureNumerator = exposureNumerator;
        return this;
    }

    /**
     * Get the fNumber property: The F-stop value from the camera. Read-only.
     * 
     * @return the fNumber value.
     */
    public Double fNumber() {
        return this.fNumber;
    }

    /**
     * Set the fNumber property: The F-stop value from the camera. Read-only.
     * 
     * @param fNumber the fNumber value to set.
     * @return the MicrosoftGraphPhoto object itself.
     */
    public MicrosoftGraphPhoto withFNumber(Double fNumber) {
        this.fNumber = fNumber;
        return this;
    }

    /**
     * Get the focalLength property: The focal length from the camera. Read-only.
     * 
     * @return the focalLength value.
     */
    public Double focalLength() {
        return this.focalLength;
    }

    /**
     * Set the focalLength property: The focal length from the camera. Read-only.
     * 
     * @param focalLength the focalLength value to set.
     * @return the MicrosoftGraphPhoto object itself.
     */
    public MicrosoftGraphPhoto withFocalLength(Double focalLength) {
        this.focalLength = focalLength;
        return this;
    }

    /**
     * Get the iso property: The ISO value from the camera. Read-only.
     * 
     * @return the iso value.
     */
    public Integer iso() {
        return this.iso;
    }

    /**
     * Set the iso property: The ISO value from the camera. Read-only.
     * 
     * @param iso the iso value to set.
     * @return the MicrosoftGraphPhoto object itself.
     */
    public MicrosoftGraphPhoto withIso(Integer iso) {
        this.iso = iso;
        return this;
    }

    /**
     * Get the orientation property: The orientation value from the camera. Writable on OneDrive Personal.
     * 
     * @return the orientation value.
     */
    public Integer orientation() {
        return this.orientation;
    }

    /**
     * Set the orientation property: The orientation value from the camera. Writable on OneDrive Personal.
     * 
     * @param orientation the orientation value to set.
     * @return the MicrosoftGraphPhoto object itself.
     */
    public MicrosoftGraphPhoto withOrientation(Integer orientation) {
        this.orientation = orientation;
        return this;
    }

    /**
     * Get the takenDateTime property: Represents the date and time the photo was taken. Read-only.
     * 
     * @return the takenDateTime value.
     */
    public OffsetDateTime takenDateTime() {
        return this.takenDateTime;
    }

    /**
     * Set the takenDateTime property: Represents the date and time the photo was taken. Read-only.
     * 
     * @param takenDateTime the takenDateTime value to set.
     * @return the MicrosoftGraphPhoto object itself.
     */
    public MicrosoftGraphPhoto withTakenDateTime(OffsetDateTime takenDateTime) {
        this.takenDateTime = takenDateTime;
        return this;
    }

    /**
     * Get the additionalProperties property: photo.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: photo.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPhoto object itself.
     */
    public MicrosoftGraphPhoto withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cameraMake", this.cameraMake);
        jsonWriter.writeStringField("cameraModel", this.cameraModel);
        jsonWriter.writeNumberField("exposureDenominator", this.exposureDenominator);
        jsonWriter.writeNumberField("exposureNumerator", this.exposureNumerator);
        jsonWriter.writeNumberField("fNumber", this.fNumber);
        jsonWriter.writeNumberField("focalLength", this.focalLength);
        jsonWriter.writeNumberField("iso", this.iso);
        jsonWriter.writeNumberField("orientation", this.orientation);
        jsonWriter.writeStringField("takenDateTime",
            this.takenDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.takenDateTime));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPhoto from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPhoto if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPhoto.
     */
    public static MicrosoftGraphPhoto fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPhoto deserializedMicrosoftGraphPhoto = new MicrosoftGraphPhoto();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cameraMake".equals(fieldName)) {
                    deserializedMicrosoftGraphPhoto.cameraMake = reader.getString();
                } else if ("cameraModel".equals(fieldName)) {
                    deserializedMicrosoftGraphPhoto.cameraModel = reader.getString();
                } else if ("exposureDenominator".equals(fieldName)) {
                    deserializedMicrosoftGraphPhoto.exposureDenominator = reader.getNullable(JsonReader::getDouble);
                } else if ("exposureNumerator".equals(fieldName)) {
                    deserializedMicrosoftGraphPhoto.exposureNumerator = reader.getNullable(JsonReader::getDouble);
                } else if ("fNumber".equals(fieldName)) {
                    deserializedMicrosoftGraphPhoto.fNumber = reader.getNullable(JsonReader::getDouble);
                } else if ("focalLength".equals(fieldName)) {
                    deserializedMicrosoftGraphPhoto.focalLength = reader.getNullable(JsonReader::getDouble);
                } else if ("iso".equals(fieldName)) {
                    deserializedMicrosoftGraphPhoto.iso = reader.getNullable(JsonReader::getInt);
                } else if ("orientation".equals(fieldName)) {
                    deserializedMicrosoftGraphPhoto.orientation = reader.getNullable(JsonReader::getInt);
                } else if ("takenDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPhoto.takenDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPhoto.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPhoto;
        });
    }
}
