// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a person or group column.
 */
@Fluent
public final class MicrosoftGraphPersonOrGroupColumn implements JsonSerializable<MicrosoftGraphPersonOrGroupColumn> {
    /*
     * Indicates whether multiple values can be selected from the source.
     */
    private Boolean allowMultipleSelection;

    /*
     * Whether to allow selection of people only, or people and groups. Must be one of peopleAndGroups or peopleOnly.
     */
    private String chooseFromType;

    /*
     * How to display the information about the person or group chosen. See below.
     */
    private String displayAs;

    /*
     * personOrGroupColumn
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPersonOrGroupColumn class.
     */
    public MicrosoftGraphPersonOrGroupColumn() {
    }

    /**
     * Get the allowMultipleSelection property: Indicates whether multiple values can be selected from the source.
     * 
     * @return the allowMultipleSelection value.
     */
    public Boolean allowMultipleSelection() {
        return this.allowMultipleSelection;
    }

    /**
     * Set the allowMultipleSelection property: Indicates whether multiple values can be selected from the source.
     * 
     * @param allowMultipleSelection the allowMultipleSelection value to set.
     * @return the MicrosoftGraphPersonOrGroupColumn object itself.
     */
    public MicrosoftGraphPersonOrGroupColumn withAllowMultipleSelection(Boolean allowMultipleSelection) {
        this.allowMultipleSelection = allowMultipleSelection;
        return this;
    }

    /**
     * Get the chooseFromType property: Whether to allow selection of people only, or people and groups. Must be one of
     * peopleAndGroups or peopleOnly.
     * 
     * @return the chooseFromType value.
     */
    public String chooseFromType() {
        return this.chooseFromType;
    }

    /**
     * Set the chooseFromType property: Whether to allow selection of people only, or people and groups. Must be one of
     * peopleAndGroups or peopleOnly.
     * 
     * @param chooseFromType the chooseFromType value to set.
     * @return the MicrosoftGraphPersonOrGroupColumn object itself.
     */
    public MicrosoftGraphPersonOrGroupColumn withChooseFromType(String chooseFromType) {
        this.chooseFromType = chooseFromType;
        return this;
    }

    /**
     * Get the displayAs property: How to display the information about the person or group chosen. See below.
     * 
     * @return the displayAs value.
     */
    public String displayAs() {
        return this.displayAs;
    }

    /**
     * Set the displayAs property: How to display the information about the person or group chosen. See below.
     * 
     * @param displayAs the displayAs value to set.
     * @return the MicrosoftGraphPersonOrGroupColumn object itself.
     */
    public MicrosoftGraphPersonOrGroupColumn withDisplayAs(String displayAs) {
        this.displayAs = displayAs;
        return this;
    }

    /**
     * Get the additionalProperties property: personOrGroupColumn.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: personOrGroupColumn.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPersonOrGroupColumn object itself.
     */
    public MicrosoftGraphPersonOrGroupColumn withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowMultipleSelection", this.allowMultipleSelection);
        jsonWriter.writeStringField("chooseFromType", this.chooseFromType);
        jsonWriter.writeStringField("displayAs", this.displayAs);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPersonOrGroupColumn from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPersonOrGroupColumn if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPersonOrGroupColumn.
     */
    public static MicrosoftGraphPersonOrGroupColumn fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPersonOrGroupColumn deserializedMicrosoftGraphPersonOrGroupColumn
                = new MicrosoftGraphPersonOrGroupColumn();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowMultipleSelection".equals(fieldName)) {
                    deserializedMicrosoftGraphPersonOrGroupColumn.allowMultipleSelection
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("chooseFromType".equals(fieldName)) {
                    deserializedMicrosoftGraphPersonOrGroupColumn.chooseFromType = reader.getString();
                } else if ("displayAs".equals(fieldName)) {
                    deserializedMicrosoftGraphPersonOrGroupColumn.displayAs = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPersonOrGroupColumn.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPersonOrGroupColumn;
        });
    }
}
