// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

/**
 * Represents a password credential.
 */
@Fluent
public final class MicrosoftGraphPasswordCredentialInner
    implements JsonSerializable<MicrosoftGraphPasswordCredentialInner> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    /*
     * Do not use.
     */
    private Base64Url customKeyIdentifier;

    /*
     * Friendly name for the password. Optional.
     */
    private String displayName;

    /*
     * The date and time at which the password expires represented using ISO 8601 format and is always in UTC time. For
     * example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Optional.
     */
    private OffsetDateTime endDateTime;

    /*
     * Contains the first three characters of the password. Read-only.
     */
    private String hint;

    /*
     * The unique identifier for the password.
     */
    private UUID keyId;

    /*
     * Read-only; Contains the strong passwords generated by Azure AD that are 16-64 characters in length. The generated
     * password value is only returned during the initial POST request to addPassword. There is no way to retrieve this
     * password in the future.
     */
    private String secretText;

    /*
     * The date and time at which the password becomes valid. The Timestamp type represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Optional.
     */
    private OffsetDateTime startDateTime;

    /*
     * passwordCredential
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPasswordCredentialInner class.
     */
    public MicrosoftGraphPasswordCredentialInner() {
    }

    /**
     * Get the customKeyIdentifier property: Do not use.
     * 
     * @return the customKeyIdentifier value.
     */
    public byte[] customKeyIdentifier() {
        if (this.customKeyIdentifier == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.customKeyIdentifier.decodedBytes();
    }

    /**
     * Set the customKeyIdentifier property: Do not use.
     * 
     * @param customKeyIdentifier the customKeyIdentifier value to set.
     * @return the MicrosoftGraphPasswordCredentialInner object itself.
     */
    public MicrosoftGraphPasswordCredentialInner withCustomKeyIdentifier(byte[] customKeyIdentifier) {
        if (customKeyIdentifier == null) {
            this.customKeyIdentifier = null;
        } else {
            this.customKeyIdentifier = Base64Url.encode(CoreUtils.clone(customKeyIdentifier));
        }
        return this;
    }

    /**
     * Get the displayName property: Friendly name for the password. Optional.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Friendly name for the password. Optional.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphPasswordCredentialInner object itself.
     */
    public MicrosoftGraphPasswordCredentialInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the endDateTime property: The date and time at which the password expires represented using ISO 8601 format
     * and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     * Optional.
     * 
     * @return the endDateTime value.
     */
    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    /**
     * Set the endDateTime property: The date and time at which the password expires represented using ISO 8601 format
     * and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     * Optional.
     * 
     * @param endDateTime the endDateTime value to set.
     * @return the MicrosoftGraphPasswordCredentialInner object itself.
     */
    public MicrosoftGraphPasswordCredentialInner withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    /**
     * Get the hint property: Contains the first three characters of the password. Read-only.
     * 
     * @return the hint value.
     */
    public String hint() {
        return this.hint;
    }

    /**
     * Set the hint property: Contains the first three characters of the password. Read-only.
     * 
     * @param hint the hint value to set.
     * @return the MicrosoftGraphPasswordCredentialInner object itself.
     */
    public MicrosoftGraphPasswordCredentialInner withHint(String hint) {
        this.hint = hint;
        return this;
    }

    /**
     * Get the keyId property: The unique identifier for the password.
     * 
     * @return the keyId value.
     */
    public UUID keyId() {
        return this.keyId;
    }

    /**
     * Set the keyId property: The unique identifier for the password.
     * 
     * @param keyId the keyId value to set.
     * @return the MicrosoftGraphPasswordCredentialInner object itself.
     */
    public MicrosoftGraphPasswordCredentialInner withKeyId(UUID keyId) {
        this.keyId = keyId;
        return this;
    }

    /**
     * Get the secretText property: Read-only; Contains the strong passwords generated by Azure AD that are 16-64
     * characters in length. The generated password value is only returned during the initial POST request to
     * addPassword. There is no way to retrieve this password in the future.
     * 
     * @return the secretText value.
     */
    public String secretText() {
        return this.secretText;
    }

    /**
     * Set the secretText property: Read-only; Contains the strong passwords generated by Azure AD that are 16-64
     * characters in length. The generated password value is only returned during the initial POST request to
     * addPassword. There is no way to retrieve this password in the future.
     * 
     * @param secretText the secretText value to set.
     * @return the MicrosoftGraphPasswordCredentialInner object itself.
     */
    public MicrosoftGraphPasswordCredentialInner withSecretText(String secretText) {
        this.secretText = secretText;
        return this;
    }

    /**
     * Get the startDateTime property: The date and time at which the password becomes valid. The Timestamp type
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Optional.
     * 
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: The date and time at which the password becomes valid. The Timestamp type
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Optional.
     * 
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphPasswordCredentialInner object itself.
     */
    public MicrosoftGraphPasswordCredentialInner withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the additionalProperties property: passwordCredential.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: passwordCredential.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPasswordCredentialInner object itself.
     */
    public MicrosoftGraphPasswordCredentialInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("customKeyIdentifier", Objects.toString(this.customKeyIdentifier, null));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("endDateTime",
            this.endDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime));
        jsonWriter.writeStringField("hint", this.hint);
        jsonWriter.writeStringField("keyId", Objects.toString(this.keyId, null));
        jsonWriter.writeStringField("secretText", this.secretText);
        jsonWriter.writeStringField("startDateTime",
            this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPasswordCredentialInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPasswordCredentialInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPasswordCredentialInner.
     */
    public static MicrosoftGraphPasswordCredentialInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPasswordCredentialInner deserializedMicrosoftGraphPasswordCredentialInner
                = new MicrosoftGraphPasswordCredentialInner();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("customKeyIdentifier".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.customKeyIdentifier
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.displayName = reader.getString();
                } else if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.endDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("hint".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.hint = reader.getString();
                } else if ("keyId".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.keyId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("secretText".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.secretText = reader.getString();
                } else if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPasswordCredentialInner.startDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPasswordCredentialInner.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPasswordCredentialInner;
        });
    }
}
