// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a page links.
 */
@Fluent
public final class MicrosoftGraphPageLinks implements JsonSerializable<MicrosoftGraphPageLinks> {
    /*
     * externalLink
     */
    private MicrosoftGraphExternalLink oneNoteClientUrl;

    /*
     * externalLink
     */
    private MicrosoftGraphExternalLink oneNoteWebUrl;

    /*
     * pageLinks
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPageLinks class.
     */
    public MicrosoftGraphPageLinks() {
    }

    /**
     * Get the oneNoteClientUrl property: externalLink.
     * 
     * @return the oneNoteClientUrl value.
     */
    public MicrosoftGraphExternalLink oneNoteClientUrl() {
        return this.oneNoteClientUrl;
    }

    /**
     * Set the oneNoteClientUrl property: externalLink.
     * 
     * @param oneNoteClientUrl the oneNoteClientUrl value to set.
     * @return the MicrosoftGraphPageLinks object itself.
     */
    public MicrosoftGraphPageLinks withOneNoteClientUrl(MicrosoftGraphExternalLink oneNoteClientUrl) {
        this.oneNoteClientUrl = oneNoteClientUrl;
        return this;
    }

    /**
     * Get the oneNoteWebUrl property: externalLink.
     * 
     * @return the oneNoteWebUrl value.
     */
    public MicrosoftGraphExternalLink oneNoteWebUrl() {
        return this.oneNoteWebUrl;
    }

    /**
     * Set the oneNoteWebUrl property: externalLink.
     * 
     * @param oneNoteWebUrl the oneNoteWebUrl value to set.
     * @return the MicrosoftGraphPageLinks object itself.
     */
    public MicrosoftGraphPageLinks withOneNoteWebUrl(MicrosoftGraphExternalLink oneNoteWebUrl) {
        this.oneNoteWebUrl = oneNoteWebUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: pageLinks.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: pageLinks.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPageLinks object itself.
     */
    public MicrosoftGraphPageLinks withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (oneNoteClientUrl() != null) {
            oneNoteClientUrl().validate();
        }
        if (oneNoteWebUrl() != null) {
            oneNoteWebUrl().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("oneNoteClientUrl", this.oneNoteClientUrl);
        jsonWriter.writeJsonField("oneNoteWebUrl", this.oneNoteWebUrl);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPageLinks from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPageLinks if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPageLinks.
     */
    public static MicrosoftGraphPageLinks fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPageLinks deserializedMicrosoftGraphPageLinks = new MicrosoftGraphPageLinks();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("oneNoteClientUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphPageLinks.oneNoteClientUrl = MicrosoftGraphExternalLink.fromJson(reader);
                } else if ("oneNoteWebUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphPageLinks.oneNoteWebUrl = MicrosoftGraphExternalLink.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPageLinks.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPageLinks;
        });
    }
}
