// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a package.
 */
@Fluent
public final class MicrosoftGraphPackage implements JsonSerializable<MicrosoftGraphPackage> {
    /*
     * A string indicating the type of package. While oneNote is the only currently defined value, you should expect
     * other package types to be returned and handle them accordingly.
     */
    private String type;

    /*
     * package
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPackage class.
     */
    public MicrosoftGraphPackage() {
    }

    /**
     * Get the type property: A string indicating the type of package. While oneNote is the only currently defined
     * value, you should expect other package types to be returned and handle them accordingly.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: A string indicating the type of package. While oneNote is the only currently defined
     * value, you should expect other package types to be returned and handle them accordingly.
     * 
     * @param type the type value to set.
     * @return the MicrosoftGraphPackage object itself.
     */
    public MicrosoftGraphPackage withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: package.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: package.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPackage object itself.
     */
    public MicrosoftGraphPackage withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPackage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPackage if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPackage.
     */
    public static MicrosoftGraphPackage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPackage deserializedMicrosoftGraphPackage = new MicrosoftGraphPackage();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphPackage.type = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPackage.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPackage;
        });
    }
}
