// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an outlook geo coordinates.
 */
@Fluent
public final class MicrosoftGraphOutlookGeoCoordinates
    implements JsonSerializable<MicrosoftGraphOutlookGeoCoordinates> {
    /*
     * The accuracy of the latitude and longitude. As an example, the accuracy can be measured in meters, such as the
     * latitude and longitude are accurate to within 50 meters.
     */
    private Double accuracy;

    /*
     * The altitude of the location.
     */
    private Double altitude;

    /*
     * The accuracy of the altitude.
     */
    private Double altitudeAccuracy;

    /*
     * The latitude of the location.
     */
    private Double latitude;

    /*
     * The longitude of the location.
     */
    private Double longitude;

    /*
     * outlookGeoCoordinates
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphOutlookGeoCoordinates class.
     */
    public MicrosoftGraphOutlookGeoCoordinates() {
    }

    /**
     * Get the accuracy property: The accuracy of the latitude and longitude. As an example, the accuracy can be
     * measured in meters, such as the latitude and longitude are accurate to within 50 meters.
     * 
     * @return the accuracy value.
     */
    public Double accuracy() {
        return this.accuracy;
    }

    /**
     * Set the accuracy property: The accuracy of the latitude and longitude. As an example, the accuracy can be
     * measured in meters, such as the latitude and longitude are accurate to within 50 meters.
     * 
     * @param accuracy the accuracy value to set.
     * @return the MicrosoftGraphOutlookGeoCoordinates object itself.
     */
    public MicrosoftGraphOutlookGeoCoordinates withAccuracy(Double accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    /**
     * Get the altitude property: The altitude of the location.
     * 
     * @return the altitude value.
     */
    public Double altitude() {
        return this.altitude;
    }

    /**
     * Set the altitude property: The altitude of the location.
     * 
     * @param altitude the altitude value to set.
     * @return the MicrosoftGraphOutlookGeoCoordinates object itself.
     */
    public MicrosoftGraphOutlookGeoCoordinates withAltitude(Double altitude) {
        this.altitude = altitude;
        return this;
    }

    /**
     * Get the altitudeAccuracy property: The accuracy of the altitude.
     * 
     * @return the altitudeAccuracy value.
     */
    public Double altitudeAccuracy() {
        return this.altitudeAccuracy;
    }

    /**
     * Set the altitudeAccuracy property: The accuracy of the altitude.
     * 
     * @param altitudeAccuracy the altitudeAccuracy value to set.
     * @return the MicrosoftGraphOutlookGeoCoordinates object itself.
     */
    public MicrosoftGraphOutlookGeoCoordinates withAltitudeAccuracy(Double altitudeAccuracy) {
        this.altitudeAccuracy = altitudeAccuracy;
        return this;
    }

    /**
     * Get the latitude property: The latitude of the location.
     * 
     * @return the latitude value.
     */
    public Double latitude() {
        return this.latitude;
    }

    /**
     * Set the latitude property: The latitude of the location.
     * 
     * @param latitude the latitude value to set.
     * @return the MicrosoftGraphOutlookGeoCoordinates object itself.
     */
    public MicrosoftGraphOutlookGeoCoordinates withLatitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    /**
     * Get the longitude property: The longitude of the location.
     * 
     * @return the longitude value.
     */
    public Double longitude() {
        return this.longitude;
    }

    /**
     * Set the longitude property: The longitude of the location.
     * 
     * @param longitude the longitude value to set.
     * @return the MicrosoftGraphOutlookGeoCoordinates object itself.
     */
    public MicrosoftGraphOutlookGeoCoordinates withLongitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    /**
     * Get the additionalProperties property: outlookGeoCoordinates.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: outlookGeoCoordinates.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOutlookGeoCoordinates object itself.
     */
    public MicrosoftGraphOutlookGeoCoordinates withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("accuracy", this.accuracy);
        jsonWriter.writeNumberField("altitude", this.altitude);
        jsonWriter.writeNumberField("altitudeAccuracy", this.altitudeAccuracy);
        jsonWriter.writeNumberField("latitude", this.latitude);
        jsonWriter.writeNumberField("longitude", this.longitude);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphOutlookGeoCoordinates from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphOutlookGeoCoordinates if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphOutlookGeoCoordinates.
     */
    public static MicrosoftGraphOutlookGeoCoordinates fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphOutlookGeoCoordinates deserializedMicrosoftGraphOutlookGeoCoordinates
                = new MicrosoftGraphOutlookGeoCoordinates();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accuracy".equals(fieldName)) {
                    deserializedMicrosoftGraphOutlookGeoCoordinates.accuracy
                        = reader.getNullable(JsonReader::getDouble);
                } else if ("altitude".equals(fieldName)) {
                    deserializedMicrosoftGraphOutlookGeoCoordinates.altitude
                        = reader.getNullable(JsonReader::getDouble);
                } else if ("altitudeAccuracy".equals(fieldName)) {
                    deserializedMicrosoftGraphOutlookGeoCoordinates.altitudeAccuracy
                        = reader.getNullable(JsonReader::getDouble);
                } else if ("latitude".equals(fieldName)) {
                    deserializedMicrosoftGraphOutlookGeoCoordinates.latitude
                        = reader.getNullable(JsonReader::getDouble);
                } else if ("longitude".equals(fieldName)) {
                    deserializedMicrosoftGraphOutlookGeoCoordinates.longitude
                        = reader.getNullable(JsonReader::getDouble);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphOutlookGeoCoordinates.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphOutlookGeoCoordinates;
        });
    }
}
