// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents an optional claims.
 */
@Fluent
public final class MicrosoftGraphOptionalClaims implements JsonSerializable<MicrosoftGraphOptionalClaims> {
    /*
     * The optional claims returned in the JWT access token.
     */
    private List<MicrosoftGraphOptionalClaim> accessToken;

    /*
     * The optional claims returned in the JWT ID token.
     */
    private List<MicrosoftGraphOptionalClaim> idToken;

    /*
     * The optional claims returned in the SAML token.
     */
    private List<MicrosoftGraphOptionalClaim> saml2Token;

    /*
     * optionalClaims
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphOptionalClaims class.
     */
    public MicrosoftGraphOptionalClaims() {
    }

    /**
     * Get the accessToken property: The optional claims returned in the JWT access token.
     * 
     * @return the accessToken value.
     */
    public List<MicrosoftGraphOptionalClaim> accessToken() {
        return this.accessToken;
    }

    /**
     * Set the accessToken property: The optional claims returned in the JWT access token.
     * 
     * @param accessToken the accessToken value to set.
     * @return the MicrosoftGraphOptionalClaims object itself.
     */
    public MicrosoftGraphOptionalClaims withAccessToken(List<MicrosoftGraphOptionalClaim> accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    /**
     * Get the idToken property: The optional claims returned in the JWT ID token.
     * 
     * @return the idToken value.
     */
    public List<MicrosoftGraphOptionalClaim> idToken() {
        return this.idToken;
    }

    /**
     * Set the idToken property: The optional claims returned in the JWT ID token.
     * 
     * @param idToken the idToken value to set.
     * @return the MicrosoftGraphOptionalClaims object itself.
     */
    public MicrosoftGraphOptionalClaims withIdToken(List<MicrosoftGraphOptionalClaim> idToken) {
        this.idToken = idToken;
        return this;
    }

    /**
     * Get the saml2Token property: The optional claims returned in the SAML token.
     * 
     * @return the saml2Token value.
     */
    public List<MicrosoftGraphOptionalClaim> saml2Token() {
        return this.saml2Token;
    }

    /**
     * Set the saml2Token property: The optional claims returned in the SAML token.
     * 
     * @param saml2Token the saml2Token value to set.
     * @return the MicrosoftGraphOptionalClaims object itself.
     */
    public MicrosoftGraphOptionalClaims withSaml2Token(List<MicrosoftGraphOptionalClaim> saml2Token) {
        this.saml2Token = saml2Token;
        return this;
    }

    /**
     * Get the additionalProperties property: optionalClaims.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: optionalClaims.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOptionalClaims object itself.
     */
    public MicrosoftGraphOptionalClaims withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (accessToken() != null) {
            accessToken().forEach(e -> e.validate());
        }
        if (idToken() != null) {
            idToken().forEach(e -> e.validate());
        }
        if (saml2Token() != null) {
            saml2Token().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("accessToken", this.accessToken, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("idToken", this.idToken, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("saml2Token", this.saml2Token, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphOptionalClaims from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphOptionalClaims if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphOptionalClaims.
     */
    public static MicrosoftGraphOptionalClaims fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphOptionalClaims deserializedMicrosoftGraphOptionalClaims = new MicrosoftGraphOptionalClaims();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accessToken".equals(fieldName)) {
                    List<MicrosoftGraphOptionalClaim> accessToken
                        = reader.readArray(reader1 -> MicrosoftGraphOptionalClaim.fromJson(reader1));
                    deserializedMicrosoftGraphOptionalClaims.accessToken = accessToken;
                } else if ("idToken".equals(fieldName)) {
                    List<MicrosoftGraphOptionalClaim> idToken
                        = reader.readArray(reader1 -> MicrosoftGraphOptionalClaim.fromJson(reader1));
                    deserializedMicrosoftGraphOptionalClaims.idToken = idToken;
                } else if ("saml2Token".equals(fieldName)) {
                    List<MicrosoftGraphOptionalClaim> saml2Token
                        = reader.readArray(reader1 -> MicrosoftGraphOptionalClaim.fromJson(reader1));
                    deserializedMicrosoftGraphOptionalClaims.saml2Token = saml2Token;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphOptionalClaims.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphOptionalClaims;
        });
    }
}
