// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an operation.
 */
@Fluent
public class MicrosoftGraphOperation extends MicrosoftGraphEntity {
    /*
     * The start time of the operation.
     */
    private OffsetDateTime createdDateTime;

    /*
     * The time of the last action of the operation.
     */
    private OffsetDateTime lastActionDateTime;

    /*
     * operationStatus
     */
    private MicrosoftGraphOperationStatus status;

    /*
     * operation
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphOperation class.
     */
    public MicrosoftGraphOperation() {
    }

    /**
     * Get the createdDateTime property: The start time of the operation.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: The start time of the operation.
     * 
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphOperation object itself.
     */
    public MicrosoftGraphOperation withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the lastActionDateTime property: The time of the last action of the operation.
     * 
     * @return the lastActionDateTime value.
     */
    public OffsetDateTime lastActionDateTime() {
        return this.lastActionDateTime;
    }

    /**
     * Set the lastActionDateTime property: The time of the last action of the operation.
     * 
     * @param lastActionDateTime the lastActionDateTime value to set.
     * @return the MicrosoftGraphOperation object itself.
     */
    public MicrosoftGraphOperation withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        this.lastActionDateTime = lastActionDateTime;
        return this;
    }

    /**
     * Get the status property: operationStatus.
     * 
     * @return the status value.
     */
    public MicrosoftGraphOperationStatus status() {
        return this.status;
    }

    /**
     * Set the status property: operationStatus.
     * 
     * @param status the status value to set.
     * @return the MicrosoftGraphOperation object itself.
     */
    public MicrosoftGraphOperation withStatus(MicrosoftGraphOperationStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the additionalProperties property: operation.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: operation.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOperation object itself.
     */
    public MicrosoftGraphOperation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphOperation withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("createdDateTime",
            this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastActionDateTime",
            this.lastActionDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastActionDateTime));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphOperation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphOperation if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphOperation.
     */
    public static MicrosoftGraphOperation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphOperation deserializedMicrosoftGraphOperation = new MicrosoftGraphOperation();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOperation.withId(reader.getString());
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOperation.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastActionDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOperation.lastActionDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphOperation.status
                        = MicrosoftGraphOperationStatus.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphOperation.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphOperation;
        });
    }
}
