// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an onenote page preview.
 */
@Fluent
public final class MicrosoftGraphOnenotePagePreview implements JsonSerializable<MicrosoftGraphOnenotePagePreview> {
    /*
     * onenotePagePreviewLinks
     */
    private MicrosoftGraphOnenotePagePreviewLinks links;

    /*
     * The previewText property.
     */
    private String previewText;

    /*
     * onenotePagePreview
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphOnenotePagePreview class.
     */
    public MicrosoftGraphOnenotePagePreview() {
    }

    /**
     * Get the links property: onenotePagePreviewLinks.
     * 
     * @return the links value.
     */
    public MicrosoftGraphOnenotePagePreviewLinks links() {
        return this.links;
    }

    /**
     * Set the links property: onenotePagePreviewLinks.
     * 
     * @param links the links value to set.
     * @return the MicrosoftGraphOnenotePagePreview object itself.
     */
    public MicrosoftGraphOnenotePagePreview withLinks(MicrosoftGraphOnenotePagePreviewLinks links) {
        this.links = links;
        return this;
    }

    /**
     * Get the previewText property: The previewText property.
     * 
     * @return the previewText value.
     */
    public String previewText() {
        return this.previewText;
    }

    /**
     * Set the previewText property: The previewText property.
     * 
     * @param previewText the previewText value to set.
     * @return the MicrosoftGraphOnenotePagePreview object itself.
     */
    public MicrosoftGraphOnenotePagePreview withPreviewText(String previewText) {
        this.previewText = previewText;
        return this;
    }

    /**
     * Get the additionalProperties property: onenotePagePreview.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: onenotePagePreview.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOnenotePagePreview object itself.
     */
    public MicrosoftGraphOnenotePagePreview withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (links() != null) {
            links().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("links", this.links);
        jsonWriter.writeStringField("previewText", this.previewText);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphOnenotePagePreview from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphOnenotePagePreview if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphOnenotePagePreview.
     */
    public static MicrosoftGraphOnenotePagePreview fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphOnenotePagePreview deserializedMicrosoftGraphOnenotePagePreview
                = new MicrosoftGraphOnenotePagePreview();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("links".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePagePreview.links
                        = MicrosoftGraphOnenotePagePreviewLinks.fromJson(reader);
                } else if ("previewText".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenotePagePreview.previewText = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphOnenotePagePreview.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphOnenotePagePreview;
        });
    }
}
