// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an onenote operation.
 */
@Fluent
public final class MicrosoftGraphOnenoteOperation extends MicrosoftGraphOperation {
    /*
     * onenoteOperationError
     */
    private MicrosoftGraphOnenoteOperationError error;

    /*
     * The operation percent complete if the operation is still in running status
     */
    private String percentComplete;

    /*
     * The resource id.
     */
    private String resourceId;

    /*
     * The resource URI for the object. For example, the resource URI for a copied page or section.
     */
    private String resourceLocation;

    /*
     * onenoteOperation
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphOnenoteOperation class.
     */
    public MicrosoftGraphOnenoteOperation() {
    }

    /**
     * Get the error property: onenoteOperationError.
     * 
     * @return the error value.
     */
    public MicrosoftGraphOnenoteOperationError error() {
        return this.error;
    }

    /**
     * Set the error property: onenoteOperationError.
     * 
     * @param error the error value to set.
     * @return the MicrosoftGraphOnenoteOperation object itself.
     */
    public MicrosoftGraphOnenoteOperation withError(MicrosoftGraphOnenoteOperationError error) {
        this.error = error;
        return this;
    }

    /**
     * Get the percentComplete property: The operation percent complete if the operation is still in running status.
     * 
     * @return the percentComplete value.
     */
    public String percentComplete() {
        return this.percentComplete;
    }

    /**
     * Set the percentComplete property: The operation percent complete if the operation is still in running status.
     * 
     * @param percentComplete the percentComplete value to set.
     * @return the MicrosoftGraphOnenoteOperation object itself.
     */
    public MicrosoftGraphOnenoteOperation withPercentComplete(String percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    /**
     * Get the resourceId property: The resource id.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The resource id.
     * 
     * @param resourceId the resourceId value to set.
     * @return the MicrosoftGraphOnenoteOperation object itself.
     */
    public MicrosoftGraphOnenoteOperation withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the resourceLocation property: The resource URI for the object. For example, the resource URI for a copied
     * page or section.
     * 
     * @return the resourceLocation value.
     */
    public String resourceLocation() {
        return this.resourceLocation;
    }

    /**
     * Set the resourceLocation property: The resource URI for the object. For example, the resource URI for a copied
     * page or section.
     * 
     * @param resourceLocation the resourceLocation value to set.
     * @return the MicrosoftGraphOnenoteOperation object itself.
     */
    public MicrosoftGraphOnenoteOperation withResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    /**
     * Get the additionalProperties property: onenoteOperation.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: onenoteOperation.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOnenoteOperation object itself.
     */
    public MicrosoftGraphOnenoteOperation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphOnenoteOperation withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphOnenoteOperation withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        super.withLastActionDateTime(lastActionDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphOnenoteOperation withStatus(MicrosoftGraphOperationStatus status) {
        super.withStatus(status);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphOnenoteOperation withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (error() != null) {
            error().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("createdDateTime",
            createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(createdDateTime()));
        jsonWriter.writeStringField("lastActionDateTime",
            lastActionDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(lastActionDateTime()));
        jsonWriter.writeStringField("status", status() == null ? null : status().toString());
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeStringField("percentComplete", this.percentComplete);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphOnenoteOperation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphOnenoteOperation if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphOnenoteOperation.
     */
    public static MicrosoftGraphOnenoteOperation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphOnenoteOperation deserializedMicrosoftGraphOnenoteOperation
                = new MicrosoftGraphOnenoteOperation();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.withId(reader.getString());
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.withCreatedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("lastActionDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.withLastActionDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation
                        .withStatus(MicrosoftGraphOperationStatus.fromString(reader.getString()));
                } else if ("error".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.error
                        = MicrosoftGraphOnenoteOperationError.fromJson(reader);
                } else if ("percentComplete".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.percentComplete = reader.getString();
                } else if ("resourceId".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.resourceId = reader.getString();
                } else if ("resourceLocation".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenoteOperation.resourceLocation = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphOnenoteOperation.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphOnenoteOperation;
        });
    }
}
