// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents an onenote.
 */
@Fluent
public final class MicrosoftGraphOnenote extends MicrosoftGraphEntity {
    /*
     * The collection of OneNote notebooks that are owned by the user or group. Read-only. Nullable.
     */
    private List<MicrosoftGraphNotebook> notebooks;

    /*
     * The status of OneNote operations. Getting an operations collection is not supported, but you can get the status
     * of long-running operations if the Operation-Location header is returned in the response. Read-only. Nullable.
     */
    private List<MicrosoftGraphOnenoteOperation> operations;

    /*
     * The pages in all OneNote notebooks that are owned by the user or group. Read-only. Nullable.
     */
    private List<MicrosoftGraphOnenotePage> pages;

    /*
     * The image and other file resources in OneNote pages. Getting a resources collection is not supported, but you can
     * get the binary content of a specific resource. Read-only. Nullable.
     */
    private List<MicrosoftGraphOnenoteResource> resources;

    /*
     * The section groups in all OneNote notebooks that are owned by the user or group. Read-only. Nullable.
     */
    private List<MicrosoftGraphSectionGroup> sectionGroups;

    /*
     * The sections in all OneNote notebooks that are owned by the user or group. Read-only. Nullable.
     */
    private List<MicrosoftGraphOnenoteSection> sections;

    /*
     * onenote
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphOnenote class.
     */
    public MicrosoftGraphOnenote() {
    }

    /**
     * Get the notebooks property: The collection of OneNote notebooks that are owned by the user or group. Read-only.
     * Nullable.
     * 
     * @return the notebooks value.
     */
    public List<MicrosoftGraphNotebook> notebooks() {
        return this.notebooks;
    }

    /**
     * Set the notebooks property: The collection of OneNote notebooks that are owned by the user or group. Read-only.
     * Nullable.
     * 
     * @param notebooks the notebooks value to set.
     * @return the MicrosoftGraphOnenote object itself.
     */
    public MicrosoftGraphOnenote withNotebooks(List<MicrosoftGraphNotebook> notebooks) {
        this.notebooks = notebooks;
        return this;
    }

    /**
     * Get the operations property: The status of OneNote operations. Getting an operations collection is not supported,
     * but you can get the status of long-running operations if the Operation-Location header is returned in the
     * response. Read-only. Nullable.
     * 
     * @return the operations value.
     */
    public List<MicrosoftGraphOnenoteOperation> operations() {
        return this.operations;
    }

    /**
     * Set the operations property: The status of OneNote operations. Getting an operations collection is not supported,
     * but you can get the status of long-running operations if the Operation-Location header is returned in the
     * response. Read-only. Nullable.
     * 
     * @param operations the operations value to set.
     * @return the MicrosoftGraphOnenote object itself.
     */
    public MicrosoftGraphOnenote withOperations(List<MicrosoftGraphOnenoteOperation> operations) {
        this.operations = operations;
        return this;
    }

    /**
     * Get the pages property: The pages in all OneNote notebooks that are owned by the user or group. Read-only.
     * Nullable.
     * 
     * @return the pages value.
     */
    public List<MicrosoftGraphOnenotePage> pages() {
        return this.pages;
    }

    /**
     * Set the pages property: The pages in all OneNote notebooks that are owned by the user or group. Read-only.
     * Nullable.
     * 
     * @param pages the pages value to set.
     * @return the MicrosoftGraphOnenote object itself.
     */
    public MicrosoftGraphOnenote withPages(List<MicrosoftGraphOnenotePage> pages) {
        this.pages = pages;
        return this;
    }

    /**
     * Get the resources property: The image and other file resources in OneNote pages. Getting a resources collection
     * is not supported, but you can get the binary content of a specific resource. Read-only. Nullable.
     * 
     * @return the resources value.
     */
    public List<MicrosoftGraphOnenoteResource> resources() {
        return this.resources;
    }

    /**
     * Set the resources property: The image and other file resources in OneNote pages. Getting a resources collection
     * is not supported, but you can get the binary content of a specific resource. Read-only. Nullable.
     * 
     * @param resources the resources value to set.
     * @return the MicrosoftGraphOnenote object itself.
     */
    public MicrosoftGraphOnenote withResources(List<MicrosoftGraphOnenoteResource> resources) {
        this.resources = resources;
        return this;
    }

    /**
     * Get the sectionGroups property: The section groups in all OneNote notebooks that are owned by the user or group.
     * Read-only. Nullable.
     * 
     * @return the sectionGroups value.
     */
    public List<MicrosoftGraphSectionGroup> sectionGroups() {
        return this.sectionGroups;
    }

    /**
     * Set the sectionGroups property: The section groups in all OneNote notebooks that are owned by the user or group.
     * Read-only. Nullable.
     * 
     * @param sectionGroups the sectionGroups value to set.
     * @return the MicrosoftGraphOnenote object itself.
     */
    public MicrosoftGraphOnenote withSectionGroups(List<MicrosoftGraphSectionGroup> sectionGroups) {
        this.sectionGroups = sectionGroups;
        return this;
    }

    /**
     * Get the sections property: The sections in all OneNote notebooks that are owned by the user or group. Read-only.
     * Nullable.
     * 
     * @return the sections value.
     */
    public List<MicrosoftGraphOnenoteSection> sections() {
        return this.sections;
    }

    /**
     * Set the sections property: The sections in all OneNote notebooks that are owned by the user or group. Read-only.
     * Nullable.
     * 
     * @param sections the sections value to set.
     * @return the MicrosoftGraphOnenote object itself.
     */
    public MicrosoftGraphOnenote withSections(List<MicrosoftGraphOnenoteSection> sections) {
        this.sections = sections;
        return this;
    }

    /**
     * Get the additionalProperties property: onenote.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: onenote.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOnenote object itself.
     */
    public MicrosoftGraphOnenote withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphOnenote withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (notebooks() != null) {
            notebooks().forEach(e -> e.validate());
        }
        if (operations() != null) {
            operations().forEach(e -> e.validate());
        }
        if (pages() != null) {
            pages().forEach(e -> e.validate());
        }
        if (resources() != null) {
            resources().forEach(e -> e.validate());
        }
        if (sectionGroups() != null) {
            sectionGroups().forEach(e -> e.validate());
        }
        if (sections() != null) {
            sections().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeArrayField("notebooks", this.notebooks, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("pages", this.pages, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("sectionGroups", this.sectionGroups, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("sections", this.sections, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphOnenote from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphOnenote if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphOnenote.
     */
    public static MicrosoftGraphOnenote fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphOnenote deserializedMicrosoftGraphOnenote = new MicrosoftGraphOnenote();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenote.withId(reader.getString());
                } else if ("notebooks".equals(fieldName)) {
                    List<MicrosoftGraphNotebook> notebooks
                        = reader.readArray(reader1 -> MicrosoftGraphNotebook.fromJson(reader1));
                    deserializedMicrosoftGraphOnenote.notebooks = notebooks;
                } else if ("operations".equals(fieldName)) {
                    List<MicrosoftGraphOnenoteOperation> operations
                        = reader.readArray(reader1 -> MicrosoftGraphOnenoteOperation.fromJson(reader1));
                    deserializedMicrosoftGraphOnenote.operations = operations;
                } else if ("pages".equals(fieldName)) {
                    List<MicrosoftGraphOnenotePage> pages
                        = reader.readArray(reader1 -> MicrosoftGraphOnenotePage.fromJson(reader1));
                    deserializedMicrosoftGraphOnenote.pages = pages;
                } else if ("resources".equals(fieldName)) {
                    List<MicrosoftGraphOnenoteResource> resources
                        = reader.readArray(reader1 -> MicrosoftGraphOnenoteResource.fromJson(reader1));
                    deserializedMicrosoftGraphOnenote.resources = resources;
                } else if ("sectionGroups".equals(fieldName)) {
                    List<MicrosoftGraphSectionGroup> sectionGroups
                        = reader.readArray(reader1 -> MicrosoftGraphSectionGroup.fromJson(reader1));
                    deserializedMicrosoftGraphOnenote.sectionGroups = sectionGroups;
                } else if ("sections".equals(fieldName)) {
                    List<MicrosoftGraphOnenoteSection> sections
                        = reader.readArray(reader1 -> MicrosoftGraphOnenoteSection.fromJson(reader1));
                    deserializedMicrosoftGraphOnenote.sections = sections;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphOnenote.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphOnenote;
        });
    }
}
