// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a message rule.
 */
@Fluent
public final class MicrosoftGraphMessageRule extends MicrosoftGraphEntity {
    /*
     * messageRuleActions
     */
    private MicrosoftGraphMessageRuleActions actions;

    /*
     * messageRulePredicates
     */
    private MicrosoftGraphMessageRulePredicates conditions;

    /*
     * The display name of the rule.
     */
    private String displayName;

    /*
     * messageRulePredicates
     */
    private MicrosoftGraphMessageRulePredicates exceptions;

    /*
     * Indicates whether the rule is in an error condition. Read-only.
     */
    private Boolean hasError;

    /*
     * Indicates whether the rule is enabled to be applied to messages.
     */
    private Boolean isEnabled;

    /*
     * Indicates if the rule is read-only and cannot be modified or deleted by the rules REST API.
     */
    private Boolean isReadOnly;

    /*
     * Indicates the order in which the rule is executed, among other rules.
     */
    private Integer sequence;

    /*
     * messageRule
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphMessageRule class.
     */
    public MicrosoftGraphMessageRule() {
    }

    /**
     * Get the actions property: messageRuleActions.
     * 
     * @return the actions value.
     */
    public MicrosoftGraphMessageRuleActions actions() {
        return this.actions;
    }

    /**
     * Set the actions property: messageRuleActions.
     * 
     * @param actions the actions value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withActions(MicrosoftGraphMessageRuleActions actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Get the conditions property: messageRulePredicates.
     * 
     * @return the conditions value.
     */
    public MicrosoftGraphMessageRulePredicates conditions() {
        return this.conditions;
    }

    /**
     * Set the conditions property: messageRulePredicates.
     * 
     * @param conditions the conditions value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withConditions(MicrosoftGraphMessageRulePredicates conditions) {
        this.conditions = conditions;
        return this;
    }

    /**
     * Get the displayName property: The display name of the rule.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the rule.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the exceptions property: messageRulePredicates.
     * 
     * @return the exceptions value.
     */
    public MicrosoftGraphMessageRulePredicates exceptions() {
        return this.exceptions;
    }

    /**
     * Set the exceptions property: messageRulePredicates.
     * 
     * @param exceptions the exceptions value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withExceptions(MicrosoftGraphMessageRulePredicates exceptions) {
        this.exceptions = exceptions;
        return this;
    }

    /**
     * Get the hasError property: Indicates whether the rule is in an error condition. Read-only.
     * 
     * @return the hasError value.
     */
    public Boolean hasError() {
        return this.hasError;
    }

    /**
     * Set the hasError property: Indicates whether the rule is in an error condition. Read-only.
     * 
     * @param hasError the hasError value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withHasError(Boolean hasError) {
        this.hasError = hasError;
        return this;
    }

    /**
     * Get the isEnabled property: Indicates whether the rule is enabled to be applied to messages.
     * 
     * @return the isEnabled value.
     */
    public Boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Set the isEnabled property: Indicates whether the rule is enabled to be applied to messages.
     * 
     * @param isEnabled the isEnabled value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    /**
     * Get the isReadOnly property: Indicates if the rule is read-only and cannot be modified or deleted by the rules
     * REST API.
     * 
     * @return the isReadOnly value.
     */
    public Boolean isReadOnly() {
        return this.isReadOnly;
    }

    /**
     * Set the isReadOnly property: Indicates if the rule is read-only and cannot be modified or deleted by the rules
     * REST API.
     * 
     * @param isReadOnly the isReadOnly value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withIsReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        return this;
    }

    /**
     * Get the sequence property: Indicates the order in which the rule is executed, among other rules.
     * 
     * @return the sequence value.
     */
    public Integer sequence() {
        return this.sequence;
    }

    /**
     * Set the sequence property: Indicates the order in which the rule is executed, among other rules.
     * 
     * @param sequence the sequence value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withSequence(Integer sequence) {
        this.sequence = sequence;
        return this;
    }

    /**
     * Get the additionalProperties property: messageRule.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: messageRule.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphMessageRule withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (actions() != null) {
            actions().validate();
        }
        if (conditions() != null) {
            conditions().validate();
        }
        if (exceptions() != null) {
            exceptions().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("actions", this.actions);
        jsonWriter.writeJsonField("conditions", this.conditions);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeJsonField("exceptions", this.exceptions);
        jsonWriter.writeBooleanField("hasError", this.hasError);
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeBooleanField("isReadOnly", this.isReadOnly);
        jsonWriter.writeNumberField("sequence", this.sequence);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphMessageRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphMessageRule if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphMessageRule.
     */
    public static MicrosoftGraphMessageRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphMessageRule deserializedMicrosoftGraphMessageRule = new MicrosoftGraphMessageRule();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphMessageRule.withId(reader.getString());
                } else if ("actions".equals(fieldName)) {
                    deserializedMicrosoftGraphMessageRule.actions = MicrosoftGraphMessageRuleActions.fromJson(reader);
                } else if ("conditions".equals(fieldName)) {
                    deserializedMicrosoftGraphMessageRule.conditions
                        = MicrosoftGraphMessageRulePredicates.fromJson(reader);
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphMessageRule.displayName = reader.getString();
                } else if ("exceptions".equals(fieldName)) {
                    deserializedMicrosoftGraphMessageRule.exceptions
                        = MicrosoftGraphMessageRulePredicates.fromJson(reader);
                } else if ("hasError".equals(fieldName)) {
                    deserializedMicrosoftGraphMessageRule.hasError = reader.getNullable(JsonReader::getBoolean);
                } else if ("isEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphMessageRule.isEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("isReadOnly".equals(fieldName)) {
                    deserializedMicrosoftGraphMessageRule.isReadOnly = reader.getNullable(JsonReader::getBoolean);
                } else if ("sequence".equals(fieldName)) {
                    deserializedMicrosoftGraphMessageRule.sequence = reader.getNullable(JsonReader::getInt);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphMessageRule.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphMessageRule;
        });
    }
}
