// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Represents a message.
 */
@Fluent
public final class MicrosoftGraphMessage extends MicrosoftGraphOutlookItem {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    /*
     * The Bcc: recipients for the message.
     */
    private List<MicrosoftGraphRecipient> bccRecipients;

    /*
     * itemBody
     */
    private MicrosoftGraphItemBody body;

    /*
     * The first 255 characters of the message body. It is in text format.
     */
    private String bodyPreview;

    /*
     * The Cc: recipients for the message.
     */
    private List<MicrosoftGraphRecipient> ccRecipients;

    /*
     * The ID of the conversation the email belongs to.
     */
    private String conversationId;

    /*
     * Indicates the position of the message within the conversation.
     */
    private Base64Url conversationIndex;

    /*
     * followupFlag
     */
    private MicrosoftGraphFollowupFlag flag;

    /*
     * recipient
     */
    private MicrosoftGraphRecipient from;

    /*
     * Indicates whether the message has attachments. This property doesn't include inline attachments, so if a message
     * contains only inline attachments, this property is false. To verify the existence of inline attachments, parse
     * the body property to look for a src attribute, such as <IMG src='cid:image001.jpg@01D26CD8.6C05F070'>.
     */
    private Boolean hasAttachments;

    /*
     * importance
     */
    private MicrosoftGraphImportance importance;

    /*
     * inferenceClassificationType
     */
    private MicrosoftGraphInferenceClassificationType inferenceClassification;

    /*
     * A collection of message headers defined by RFC5322. The set includes message headers indicating the network path
     * taken by a message from the sender to the recipient. It can also contain custom message headers that hold app
     * data for the message. Returned only on applying a $select query option. Read-only.
     */
    private List<MicrosoftGraphInternetMessageHeader> internetMessageHeaders;

    /*
     * The message ID in the format specified by RFC2822.
     */
    private String internetMessageId;

    /*
     * Indicates whether a read receipt is requested for the message.
     */
    private Boolean isDeliveryReceiptRequested;

    /*
     * Indicates whether the message is a draft. A message is a draft if it hasn't been sent yet.
     */
    private Boolean isDraft;

    /*
     * Indicates whether the message has been read.
     */
    private Boolean isRead;

    /*
     * Indicates whether a read receipt is requested for the message.
     */
    private Boolean isReadReceiptRequested;

    /*
     * The unique identifier for the message's parent mailFolder.
     */
    private String parentFolderId;

    /*
     * The date and time the message was received. The date and time information uses ISO 8601 format and is always in
     * UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     */
    private OffsetDateTime receivedDateTime;

    /*
     * The email addresses to use when replying.
     */
    private List<MicrosoftGraphRecipient> replyTo;

    /*
     * recipient
     */
    private MicrosoftGraphRecipient sender;

    /*
     * The date and time the message was sent. The date and time information uses ISO 8601 format and is always in UTC
     * time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     */
    private OffsetDateTime sentDateTime;

    /*
     * The subject of the message.
     */
    private String subject;

    /*
     * The To: recipients for the message.
     */
    private List<MicrosoftGraphRecipient> toRecipients;

    /*
     * itemBody
     */
    private MicrosoftGraphItemBody uniqueBody;

    /*
     * The URL to open the message in Outlook on the web.You can append an ispopout argument to the end of the URL to
     * change how the message is displayed. If ispopout is not present or if it is set to 1, then the message is shown
     * in a popout window. If ispopout is set to 0, then the browser will show the message in the Outlook on the web
     * review pane.The message will open in the browser if you are logged in to your mailbox via Outlook on the web. You
     * will be prompted to login if you are not already logged in with the browser.This URL cannot be accessed from
     * within an iFrame.
     */
    private String webLink;

    /*
     * The fileAttachment and itemAttachment attachments for the message.
     */
    private List<MicrosoftGraphAttachment> attachments;

    /*
     * The collection of open extensions defined for the message. Nullable.
     */
    private List<MicrosoftGraphExtension> extensions;

    /*
     * The collection of multi-value extended properties defined for the message. Nullable.
     */
    private List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    /*
     * The collection of single-value extended properties defined for the message. Nullable.
     */
    private List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    /*
     * message
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphMessage class.
     */
    public MicrosoftGraphMessage() {
    }

    /**
     * Get the bccRecipients property: The Bcc: recipients for the message.
     * 
     * @return the bccRecipients value.
     */
    public List<MicrosoftGraphRecipient> bccRecipients() {
        return this.bccRecipients;
    }

    /**
     * Set the bccRecipients property: The Bcc: recipients for the message.
     * 
     * @param bccRecipients the bccRecipients value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withBccRecipients(List<MicrosoftGraphRecipient> bccRecipients) {
        this.bccRecipients = bccRecipients;
        return this;
    }

    /**
     * Get the body property: itemBody.
     * 
     * @return the body value.
     */
    public MicrosoftGraphItemBody body() {
        return this.body;
    }

    /**
     * Set the body property: itemBody.
     * 
     * @param body the body value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withBody(MicrosoftGraphItemBody body) {
        this.body = body;
        return this;
    }

    /**
     * Get the bodyPreview property: The first 255 characters of the message body. It is in text format.
     * 
     * @return the bodyPreview value.
     */
    public String bodyPreview() {
        return this.bodyPreview;
    }

    /**
     * Set the bodyPreview property: The first 255 characters of the message body. It is in text format.
     * 
     * @param bodyPreview the bodyPreview value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withBodyPreview(String bodyPreview) {
        this.bodyPreview = bodyPreview;
        return this;
    }

    /**
     * Get the ccRecipients property: The Cc: recipients for the message.
     * 
     * @return the ccRecipients value.
     */
    public List<MicrosoftGraphRecipient> ccRecipients() {
        return this.ccRecipients;
    }

    /**
     * Set the ccRecipients property: The Cc: recipients for the message.
     * 
     * @param ccRecipients the ccRecipients value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withCcRecipients(List<MicrosoftGraphRecipient> ccRecipients) {
        this.ccRecipients = ccRecipients;
        return this;
    }

    /**
     * Get the conversationId property: The ID of the conversation the email belongs to.
     * 
     * @return the conversationId value.
     */
    public String conversationId() {
        return this.conversationId;
    }

    /**
     * Set the conversationId property: The ID of the conversation the email belongs to.
     * 
     * @param conversationId the conversationId value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withConversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    /**
     * Get the conversationIndex property: Indicates the position of the message within the conversation.
     * 
     * @return the conversationIndex value.
     */
    public byte[] conversationIndex() {
        if (this.conversationIndex == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.conversationIndex.decodedBytes();
    }

    /**
     * Set the conversationIndex property: Indicates the position of the message within the conversation.
     * 
     * @param conversationIndex the conversationIndex value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withConversationIndex(byte[] conversationIndex) {
        if (conversationIndex == null) {
            this.conversationIndex = null;
        } else {
            this.conversationIndex = Base64Url.encode(CoreUtils.clone(conversationIndex));
        }
        return this;
    }

    /**
     * Get the flag property: followupFlag.
     * 
     * @return the flag value.
     */
    public MicrosoftGraphFollowupFlag flag() {
        return this.flag;
    }

    /**
     * Set the flag property: followupFlag.
     * 
     * @param flag the flag value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withFlag(MicrosoftGraphFollowupFlag flag) {
        this.flag = flag;
        return this;
    }

    /**
     * Get the from property: recipient.
     * 
     * @return the from value.
     */
    public MicrosoftGraphRecipient from() {
        return this.from;
    }

    /**
     * Set the from property: recipient.
     * 
     * @param from the from value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withFrom(MicrosoftGraphRecipient from) {
        this.from = from;
        return this;
    }

    /**
     * Get the hasAttachments property: Indicates whether the message has attachments. This property doesn't include
     * inline attachments, so if a message contains only inline attachments, this property is false. To verify the
     * existence of inline attachments, parse the body property to look for a src attribute, such as &lt;IMG
     * src='cid:image001.jpg&#064;01D26CD8.6C05F070'&gt;.
     * 
     * @return the hasAttachments value.
     */
    public Boolean hasAttachments() {
        return this.hasAttachments;
    }

    /**
     * Set the hasAttachments property: Indicates whether the message has attachments. This property doesn't include
     * inline attachments, so if a message contains only inline attachments, this property is false. To verify the
     * existence of inline attachments, parse the body property to look for a src attribute, such as &lt;IMG
     * src='cid:image001.jpg&#064;01D26CD8.6C05F070'&gt;.
     * 
     * @param hasAttachments the hasAttachments value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    /**
     * Get the importance property: importance.
     * 
     * @return the importance value.
     */
    public MicrosoftGraphImportance importance() {
        return this.importance;
    }

    /**
     * Set the importance property: importance.
     * 
     * @param importance the importance value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withImportance(MicrosoftGraphImportance importance) {
        this.importance = importance;
        return this;
    }

    /**
     * Get the inferenceClassification property: inferenceClassificationType.
     * 
     * @return the inferenceClassification value.
     */
    public MicrosoftGraphInferenceClassificationType inferenceClassification() {
        return this.inferenceClassification;
    }

    /**
     * Set the inferenceClassification property: inferenceClassificationType.
     * 
     * @param inferenceClassification the inferenceClassification value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage
        withInferenceClassification(MicrosoftGraphInferenceClassificationType inferenceClassification) {
        this.inferenceClassification = inferenceClassification;
        return this;
    }

    /**
     * Get the internetMessageHeaders property: A collection of message headers defined by RFC5322. The set includes
     * message headers indicating the network path taken by a message from the sender to the recipient. It can also
     * contain custom message headers that hold app data for the message. Returned only on applying a $select query
     * option. Read-only.
     * 
     * @return the internetMessageHeaders value.
     */
    public List<MicrosoftGraphInternetMessageHeader> internetMessageHeaders() {
        return this.internetMessageHeaders;
    }

    /**
     * Set the internetMessageHeaders property: A collection of message headers defined by RFC5322. The set includes
     * message headers indicating the network path taken by a message from the sender to the recipient. It can also
     * contain custom message headers that hold app data for the message. Returned only on applying a $select query
     * option. Read-only.
     * 
     * @param internetMessageHeaders the internetMessageHeaders value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage
        withInternetMessageHeaders(List<MicrosoftGraphInternetMessageHeader> internetMessageHeaders) {
        this.internetMessageHeaders = internetMessageHeaders;
        return this;
    }

    /**
     * Get the internetMessageId property: The message ID in the format specified by RFC2822.
     * 
     * @return the internetMessageId value.
     */
    public String internetMessageId() {
        return this.internetMessageId;
    }

    /**
     * Set the internetMessageId property: The message ID in the format specified by RFC2822.
     * 
     * @param internetMessageId the internetMessageId value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withInternetMessageId(String internetMessageId) {
        this.internetMessageId = internetMessageId;
        return this;
    }

    /**
     * Get the isDeliveryReceiptRequested property: Indicates whether a read receipt is requested for the message.
     * 
     * @return the isDeliveryReceiptRequested value.
     */
    public Boolean isDeliveryReceiptRequested() {
        return this.isDeliveryReceiptRequested;
    }

    /**
     * Set the isDeliveryReceiptRequested property: Indicates whether a read receipt is requested for the message.
     * 
     * @param isDeliveryReceiptRequested the isDeliveryReceiptRequested value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withIsDeliveryReceiptRequested(Boolean isDeliveryReceiptRequested) {
        this.isDeliveryReceiptRequested = isDeliveryReceiptRequested;
        return this;
    }

    /**
     * Get the isDraft property: Indicates whether the message is a draft. A message is a draft if it hasn't been sent
     * yet.
     * 
     * @return the isDraft value.
     */
    public Boolean isDraft() {
        return this.isDraft;
    }

    /**
     * Set the isDraft property: Indicates whether the message is a draft. A message is a draft if it hasn't been sent
     * yet.
     * 
     * @param isDraft the isDraft value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withIsDraft(Boolean isDraft) {
        this.isDraft = isDraft;
        return this;
    }

    /**
     * Get the isRead property: Indicates whether the message has been read.
     * 
     * @return the isRead value.
     */
    public Boolean isRead() {
        return this.isRead;
    }

    /**
     * Set the isRead property: Indicates whether the message has been read.
     * 
     * @param isRead the isRead value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withIsRead(Boolean isRead) {
        this.isRead = isRead;
        return this;
    }

    /**
     * Get the isReadReceiptRequested property: Indicates whether a read receipt is requested for the message.
     * 
     * @return the isReadReceiptRequested value.
     */
    public Boolean isReadReceiptRequested() {
        return this.isReadReceiptRequested;
    }

    /**
     * Set the isReadReceiptRequested property: Indicates whether a read receipt is requested for the message.
     * 
     * @param isReadReceiptRequested the isReadReceiptRequested value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withIsReadReceiptRequested(Boolean isReadReceiptRequested) {
        this.isReadReceiptRequested = isReadReceiptRequested;
        return this;
    }

    /**
     * Get the parentFolderId property: The unique identifier for the message's parent mailFolder.
     * 
     * @return the parentFolderId value.
     */
    public String parentFolderId() {
        return this.parentFolderId;
    }

    /**
     * Set the parentFolderId property: The unique identifier for the message's parent mailFolder.
     * 
     * @param parentFolderId the parentFolderId value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withParentFolderId(String parentFolderId) {
        this.parentFolderId = parentFolderId;
        return this;
    }

    /**
     * Get the receivedDateTime property: The date and time the message was received. The date and time information uses
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     * 
     * @return the receivedDateTime value.
     */
    public OffsetDateTime receivedDateTime() {
        return this.receivedDateTime;
    }

    /**
     * Set the receivedDateTime property: The date and time the message was received. The date and time information uses
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     * 
     * @param receivedDateTime the receivedDateTime value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withReceivedDateTime(OffsetDateTime receivedDateTime) {
        this.receivedDateTime = receivedDateTime;
        return this;
    }

    /**
     * Get the replyTo property: The email addresses to use when replying.
     * 
     * @return the replyTo value.
     */
    public List<MicrosoftGraphRecipient> replyTo() {
        return this.replyTo;
    }

    /**
     * Set the replyTo property: The email addresses to use when replying.
     * 
     * @param replyTo the replyTo value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withReplyTo(List<MicrosoftGraphRecipient> replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    /**
     * Get the sender property: recipient.
     * 
     * @return the sender value.
     */
    public MicrosoftGraphRecipient sender() {
        return this.sender;
    }

    /**
     * Set the sender property: recipient.
     * 
     * @param sender the sender value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withSender(MicrosoftGraphRecipient sender) {
        this.sender = sender;
        return this;
    }

    /**
     * Get the sentDateTime property: The date and time the message was sent. The date and time information uses ISO
     * 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     * 
     * @return the sentDateTime value.
     */
    public OffsetDateTime sentDateTime() {
        return this.sentDateTime;
    }

    /**
     * Set the sentDateTime property: The date and time the message was sent. The date and time information uses ISO
     * 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     * 
     * @param sentDateTime the sentDateTime value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withSentDateTime(OffsetDateTime sentDateTime) {
        this.sentDateTime = sentDateTime;
        return this;
    }

    /**
     * Get the subject property: The subject of the message.
     * 
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Set the subject property: The subject of the message.
     * 
     * @param subject the subject value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Get the toRecipients property: The To: recipients for the message.
     * 
     * @return the toRecipients value.
     */
    public List<MicrosoftGraphRecipient> toRecipients() {
        return this.toRecipients;
    }

    /**
     * Set the toRecipients property: The To: recipients for the message.
     * 
     * @param toRecipients the toRecipients value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withToRecipients(List<MicrosoftGraphRecipient> toRecipients) {
        this.toRecipients = toRecipients;
        return this;
    }

    /**
     * Get the uniqueBody property: itemBody.
     * 
     * @return the uniqueBody value.
     */
    public MicrosoftGraphItemBody uniqueBody() {
        return this.uniqueBody;
    }

    /**
     * Set the uniqueBody property: itemBody.
     * 
     * @param uniqueBody the uniqueBody value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withUniqueBody(MicrosoftGraphItemBody uniqueBody) {
        this.uniqueBody = uniqueBody;
        return this;
    }

    /**
     * Get the webLink property: The URL to open the message in Outlook on the web.You can append an ispopout argument
     * to the end of the URL to change how the message is displayed. If ispopout is not present or if it is set to 1,
     * then the message is shown in a popout window. If ispopout is set to 0, then the browser will show the message in
     * the Outlook on the web review pane.The message will open in the browser if you are logged in to your mailbox via
     * Outlook on the web. You will be prompted to login if you are not already logged in with the browser.This URL
     * cannot be accessed from within an iFrame.
     * 
     * @return the webLink value.
     */
    public String webLink() {
        return this.webLink;
    }

    /**
     * Set the webLink property: The URL to open the message in Outlook on the web.You can append an ispopout argument
     * to the end of the URL to change how the message is displayed. If ispopout is not present or if it is set to 1,
     * then the message is shown in a popout window. If ispopout is set to 0, then the browser will show the message in
     * the Outlook on the web review pane.The message will open in the browser if you are logged in to your mailbox via
     * Outlook on the web. You will be prompted to login if you are not already logged in with the browser.This URL
     * cannot be accessed from within an iFrame.
     * 
     * @param webLink the webLink value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withWebLink(String webLink) {
        this.webLink = webLink;
        return this;
    }

    /**
     * Get the attachments property: The fileAttachment and itemAttachment attachments for the message.
     * 
     * @return the attachments value.
     */
    public List<MicrosoftGraphAttachment> attachments() {
        return this.attachments;
    }

    /**
     * Set the attachments property: The fileAttachment and itemAttachment attachments for the message.
     * 
     * @param attachments the attachments value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withAttachments(List<MicrosoftGraphAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    /**
     * Get the extensions property: The collection of open extensions defined for the message. Nullable.
     * 
     * @return the extensions value.
     */
    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: The collection of open extensions defined for the message. Nullable.
     * 
     * @param extensions the extensions value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * message. Nullable.
     * 
     * @return the multiValueExtendedProperties value.
     */
    public List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties() {
        return this.multiValueExtendedProperties;
    }

    /**
     * Set the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * message. Nullable.
     * 
     * @param multiValueExtendedProperties the multiValueExtendedProperties value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withMultiValueExtendedProperties(
        List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        this.multiValueExtendedProperties = multiValueExtendedProperties;
        return this;
    }

    /**
     * Get the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the message. Nullable.
     * 
     * @return the singleValueExtendedProperties value.
     */
    public List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties() {
        return this.singleValueExtendedProperties;
    }

    /**
     * Set the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the message. Nullable.
     * 
     * @param singleValueExtendedProperties the singleValueExtendedProperties value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withSingleValueExtendedProperties(
        List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        this.singleValueExtendedProperties = singleValueExtendedProperties;
        return this;
    }

    /**
     * Get the additionalProperties property: message.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: message.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphMessage withCategories(List<String> categories) {
        super.withCategories(categories);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphMessage withChangeKey(String changeKey) {
        super.withChangeKey(changeKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphMessage withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphMessage withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphMessage withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (bccRecipients() != null) {
            bccRecipients().forEach(e -> e.validate());
        }
        if (body() != null) {
            body().validate();
        }
        if (ccRecipients() != null) {
            ccRecipients().forEach(e -> e.validate());
        }
        if (flag() != null) {
            flag().validate();
        }
        if (from() != null) {
            from().validate();
        }
        if (internetMessageHeaders() != null) {
            internetMessageHeaders().forEach(e -> e.validate());
        }
        if (replyTo() != null) {
            replyTo().forEach(e -> e.validate());
        }
        if (sender() != null) {
            sender().validate();
        }
        if (toRecipients() != null) {
            toRecipients().forEach(e -> e.validate());
        }
        if (uniqueBody() != null) {
            uniqueBody().validate();
        }
        if (attachments() != null) {
            attachments().forEach(e -> e.validate());
        }
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
        if (multiValueExtendedProperties() != null) {
            multiValueExtendedProperties().forEach(e -> e.validate());
        }
        if (singleValueExtendedProperties() != null) {
            singleValueExtendedProperties().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeArrayField("categories", categories(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("changeKey", changeKey());
        jsonWriter.writeStringField("createdDateTime",
            createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(createdDateTime()));
        jsonWriter.writeStringField("lastModifiedDateTime",
            lastModifiedDateTime() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(lastModifiedDateTime()));
        jsonWriter.writeArrayField("bccRecipients", this.bccRecipients, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("body", this.body);
        jsonWriter.writeStringField("bodyPreview", this.bodyPreview);
        jsonWriter.writeArrayField("ccRecipients", this.ccRecipients, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("conversationId", this.conversationId);
        jsonWriter.writeStringField("conversationIndex", Objects.toString(this.conversationIndex, null));
        jsonWriter.writeJsonField("flag", this.flag);
        jsonWriter.writeJsonField("from", this.from);
        jsonWriter.writeBooleanField("hasAttachments", this.hasAttachments);
        jsonWriter.writeStringField("importance", this.importance == null ? null : this.importance.toString());
        jsonWriter.writeStringField("inferenceClassification",
            this.inferenceClassification == null ? null : this.inferenceClassification.toString());
        jsonWriter.writeArrayField("internetMessageHeaders", this.internetMessageHeaders,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("internetMessageId", this.internetMessageId);
        jsonWriter.writeBooleanField("isDeliveryReceiptRequested", this.isDeliveryReceiptRequested);
        jsonWriter.writeBooleanField("isDraft", this.isDraft);
        jsonWriter.writeBooleanField("isRead", this.isRead);
        jsonWriter.writeBooleanField("isReadReceiptRequested", this.isReadReceiptRequested);
        jsonWriter.writeStringField("parentFolderId", this.parentFolderId);
        jsonWriter.writeStringField("receivedDateTime",
            this.receivedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.receivedDateTime));
        jsonWriter.writeArrayField("replyTo", this.replyTo, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("sender", this.sender);
        jsonWriter.writeStringField("sentDateTime",
            this.sentDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.sentDateTime));
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeArrayField("toRecipients", this.toRecipients, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("uniqueBody", this.uniqueBody);
        jsonWriter.writeStringField("webLink", this.webLink);
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("multiValueExtendedProperties", this.multiValueExtendedProperties,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("singleValueExtendedProperties", this.singleValueExtendedProperties,
            (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphMessage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphMessage if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphMessage.
     */
    public static MicrosoftGraphMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphMessage deserializedMicrosoftGraphMessage = new MicrosoftGraphMessage();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.withId(reader.getString());
                } else if ("categories".equals(fieldName)) {
                    List<String> categories = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphMessage.withCategories(categories);
                } else if ("changeKey".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.withChangeKey(reader.getString());
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.withCreatedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.withLastModifiedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("bccRecipients".equals(fieldName)) {
                    List<MicrosoftGraphRecipient> bccRecipients
                        = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    deserializedMicrosoftGraphMessage.bccRecipients = bccRecipients;
                } else if ("body".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.body = MicrosoftGraphItemBody.fromJson(reader);
                } else if ("bodyPreview".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.bodyPreview = reader.getString();
                } else if ("ccRecipients".equals(fieldName)) {
                    List<MicrosoftGraphRecipient> ccRecipients
                        = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    deserializedMicrosoftGraphMessage.ccRecipients = ccRecipients;
                } else if ("conversationId".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.conversationId = reader.getString();
                } else if ("conversationIndex".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.conversationIndex
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("flag".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.flag = MicrosoftGraphFollowupFlag.fromJson(reader);
                } else if ("from".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.from = MicrosoftGraphRecipient.fromJson(reader);
                } else if ("hasAttachments".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.hasAttachments = reader.getNullable(JsonReader::getBoolean);
                } else if ("importance".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.importance
                        = MicrosoftGraphImportance.fromString(reader.getString());
                } else if ("inferenceClassification".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.inferenceClassification
                        = MicrosoftGraphInferenceClassificationType.fromString(reader.getString());
                } else if ("internetMessageHeaders".equals(fieldName)) {
                    List<MicrosoftGraphInternetMessageHeader> internetMessageHeaders
                        = reader.readArray(reader1 -> MicrosoftGraphInternetMessageHeader.fromJson(reader1));
                    deserializedMicrosoftGraphMessage.internetMessageHeaders = internetMessageHeaders;
                } else if ("internetMessageId".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.internetMessageId = reader.getString();
                } else if ("isDeliveryReceiptRequested".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.isDeliveryReceiptRequested
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("isDraft".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.isDraft = reader.getNullable(JsonReader::getBoolean);
                } else if ("isRead".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.isRead = reader.getNullable(JsonReader::getBoolean);
                } else if ("isReadReceiptRequested".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.isReadReceiptRequested
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("parentFolderId".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.parentFolderId = reader.getString();
                } else if ("receivedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.receivedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("replyTo".equals(fieldName)) {
                    List<MicrosoftGraphRecipient> replyTo
                        = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    deserializedMicrosoftGraphMessage.replyTo = replyTo;
                } else if ("sender".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.sender = MicrosoftGraphRecipient.fromJson(reader);
                } else if ("sentDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.sentDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("subject".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.subject = reader.getString();
                } else if ("toRecipients".equals(fieldName)) {
                    List<MicrosoftGraphRecipient> toRecipients
                        = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    deserializedMicrosoftGraphMessage.toRecipients = toRecipients;
                } else if ("uniqueBody".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.uniqueBody = MicrosoftGraphItemBody.fromJson(reader);
                } else if ("webLink".equals(fieldName)) {
                    deserializedMicrosoftGraphMessage.webLink = reader.getString();
                } else if ("attachments".equals(fieldName)) {
                    List<MicrosoftGraphAttachment> attachments
                        = reader.readArray(reader1 -> MicrosoftGraphAttachment.fromJson(reader1));
                    deserializedMicrosoftGraphMessage.attachments = attachments;
                } else if ("extensions".equals(fieldName)) {
                    List<MicrosoftGraphExtension> extensions
                        = reader.readArray(reader1 -> MicrosoftGraphExtension.fromJson(reader1));
                    deserializedMicrosoftGraphMessage.extensions = extensions;
                } else if ("multiValueExtendedProperties".equals(fieldName)) {
                    List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties
                        = reader.readArray(reader1 -> MicrosoftGraphMultiValueLegacyExtendedProperty.fromJson(reader1));
                    deserializedMicrosoftGraphMessage.multiValueExtendedProperties = multiValueExtendedProperties;
                } else if ("singleValueExtendedProperties".equals(fieldName)) {
                    List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties = reader
                        .readArray(reader1 -> MicrosoftGraphSingleValueLegacyExtendedProperty.fromJson(reader1));
                    deserializedMicrosoftGraphMessage.singleValueExtendedProperties = singleValueExtendedProperties;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphMessage.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphMessage;
        });
    }
}
