// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a list info.
 */
@Fluent
public final class MicrosoftGraphListInfo implements JsonSerializable<MicrosoftGraphListInfo> {
    /*
     * If true, indicates that content types are enabled for this list.
     */
    private Boolean contentTypesEnabled;

    /*
     * If true, indicates that the list is not normally visible in the SharePoint user experience.
     */
    private Boolean hidden;

    /*
     * An enumerated value that represents the base list template used in creating the list. Possible values include
     * documentLibrary, genericList, task, survey, announcements, contacts, and more.
     */
    private String template;

    /*
     * listInfo
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphListInfo class.
     */
    public MicrosoftGraphListInfo() {
    }

    /**
     * Get the contentTypesEnabled property: If true, indicates that content types are enabled for this list.
     * 
     * @return the contentTypesEnabled value.
     */
    public Boolean contentTypesEnabled() {
        return this.contentTypesEnabled;
    }

    /**
     * Set the contentTypesEnabled property: If true, indicates that content types are enabled for this list.
     * 
     * @param contentTypesEnabled the contentTypesEnabled value to set.
     * @return the MicrosoftGraphListInfo object itself.
     */
    public MicrosoftGraphListInfo withContentTypesEnabled(Boolean contentTypesEnabled) {
        this.contentTypesEnabled = contentTypesEnabled;
        return this;
    }

    /**
     * Get the hidden property: If true, indicates that the list is not normally visible in the SharePoint user
     * experience.
     * 
     * @return the hidden value.
     */
    public Boolean hidden() {
        return this.hidden;
    }

    /**
     * Set the hidden property: If true, indicates that the list is not normally visible in the SharePoint user
     * experience.
     * 
     * @param hidden the hidden value to set.
     * @return the MicrosoftGraphListInfo object itself.
     */
    public MicrosoftGraphListInfo withHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    /**
     * Get the template property: An enumerated value that represents the base list template used in creating the list.
     * Possible values include documentLibrary, genericList, task, survey, announcements, contacts, and more.
     * 
     * @return the template value.
     */
    public String template() {
        return this.template;
    }

    /**
     * Set the template property: An enumerated value that represents the base list template used in creating the list.
     * Possible values include documentLibrary, genericList, task, survey, announcements, contacts, and more.
     * 
     * @param template the template value to set.
     * @return the MicrosoftGraphListInfo object itself.
     */
    public MicrosoftGraphListInfo withTemplate(String template) {
        this.template = template;
        return this;
    }

    /**
     * Get the additionalProperties property: listInfo.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: listInfo.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphListInfo object itself.
     */
    public MicrosoftGraphListInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("contentTypesEnabled", this.contentTypesEnabled);
        jsonWriter.writeBooleanField("hidden", this.hidden);
        jsonWriter.writeStringField("template", this.template);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphListInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphListInfo if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphListInfo.
     */
    public static MicrosoftGraphListInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphListInfo deserializedMicrosoftGraphListInfo = new MicrosoftGraphListInfo();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("contentTypesEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphListInfo.contentTypesEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("hidden".equals(fieldName)) {
                    deserializedMicrosoftGraphListInfo.hidden = reader.getNullable(JsonReader::getBoolean);
                } else if ("template".equals(fieldName)) {
                    deserializedMicrosoftGraphListInfo.template = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphListInfo.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphListInfo;
        });
    }
}
