// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a linked resource.
 */
@Fluent
public final class MicrosoftGraphLinkedResource extends MicrosoftGraphEntity {
    /*
     * Field indicating the app name of the source that is sending the linkedResource.
     */
    private String applicationName;

    /*
     * Field indicating the title of the linkedResource.
     */
    private String displayName;

    /*
     * Id of the object that is associated with this task on the third-party/partner system.
     */
    private String externalId;

    /*
     * Deep link to the linkedResource.
     */
    private String webUrl;

    /*
     * linkedResource
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphLinkedResource class.
     */
    public MicrosoftGraphLinkedResource() {
    }

    /**
     * Get the applicationName property: Field indicating the app name of the source that is sending the linkedResource.
     * 
     * @return the applicationName value.
     */
    public String applicationName() {
        return this.applicationName;
    }

    /**
     * Set the applicationName property: Field indicating the app name of the source that is sending the linkedResource.
     * 
     * @param applicationName the applicationName value to set.
     * @return the MicrosoftGraphLinkedResource object itself.
     */
    public MicrosoftGraphLinkedResource withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    /**
     * Get the displayName property: Field indicating the title of the linkedResource.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Field indicating the title of the linkedResource.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphLinkedResource object itself.
     */
    public MicrosoftGraphLinkedResource withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the externalId property: Id of the object that is associated with this task on the third-party/partner
     * system.
     * 
     * @return the externalId value.
     */
    public String externalId() {
        return this.externalId;
    }

    /**
     * Set the externalId property: Id of the object that is associated with this task on the third-party/partner
     * system.
     * 
     * @param externalId the externalId value to set.
     * @return the MicrosoftGraphLinkedResource object itself.
     */
    public MicrosoftGraphLinkedResource withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    /**
     * Get the webUrl property: Deep link to the linkedResource.
     * 
     * @return the webUrl value.
     */
    public String webUrl() {
        return this.webUrl;
    }

    /**
     * Set the webUrl property: Deep link to the linkedResource.
     * 
     * @param webUrl the webUrl value to set.
     * @return the MicrosoftGraphLinkedResource object itself.
     */
    public MicrosoftGraphLinkedResource withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: linkedResource.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: linkedResource.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphLinkedResource object itself.
     */
    public MicrosoftGraphLinkedResource withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphLinkedResource withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("applicationName", this.applicationName);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("externalId", this.externalId);
        jsonWriter.writeStringField("webUrl", this.webUrl);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphLinkedResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphLinkedResource if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphLinkedResource.
     */
    public static MicrosoftGraphLinkedResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphLinkedResource deserializedMicrosoftGraphLinkedResource = new MicrosoftGraphLinkedResource();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphLinkedResource.withId(reader.getString());
                } else if ("applicationName".equals(fieldName)) {
                    deserializedMicrosoftGraphLinkedResource.applicationName = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphLinkedResource.displayName = reader.getString();
                } else if ("externalId".equals(fieldName)) {
                    deserializedMicrosoftGraphLinkedResource.externalId = reader.getString();
                } else if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphLinkedResource.webUrl = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphLinkedResource.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphLinkedResource;
        });
    }
}
