// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a license processing state.
 */
@Fluent
public final class MicrosoftGraphLicenseProcessingState
    implements JsonSerializable<MicrosoftGraphLicenseProcessingState> {
    /*
     * The state property.
     */
    private String state;

    /*
     * licenseProcessingState
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphLicenseProcessingState class.
     */
    public MicrosoftGraphLicenseProcessingState() {
    }

    /**
     * Get the state property: The state property.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state property: The state property.
     * 
     * @param state the state value to set.
     * @return the MicrosoftGraphLicenseProcessingState object itself.
     */
    public MicrosoftGraphLicenseProcessingState withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Get the additionalProperties property: licenseProcessingState.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: licenseProcessingState.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphLicenseProcessingState object itself.
     */
    public MicrosoftGraphLicenseProcessingState withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphLicenseProcessingState from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphLicenseProcessingState if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphLicenseProcessingState.
     */
    public static MicrosoftGraphLicenseProcessingState fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphLicenseProcessingState deserializedMicrosoftGraphLicenseProcessingState
                = new MicrosoftGraphLicenseProcessingState();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedMicrosoftGraphLicenseProcessingState.state = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphLicenseProcessingState.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphLicenseProcessingState;
        });
    }
}
