// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an item body.
 */
@Fluent
public final class MicrosoftGraphItemBody implements JsonSerializable<MicrosoftGraphItemBody> {
    /*
     * The content of the item.
     */
    private String content;

    /*
     * bodyType
     */
    private MicrosoftGraphBodyType contentType;

    /*
     * itemBody
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphItemBody class.
     */
    public MicrosoftGraphItemBody() {
    }

    /**
     * Get the content property: The content of the item.
     * 
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: The content of the item.
     * 
     * @param content the content value to set.
     * @return the MicrosoftGraphItemBody object itself.
     */
    public MicrosoftGraphItemBody withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the contentType property: bodyType.
     * 
     * @return the contentType value.
     */
    public MicrosoftGraphBodyType contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: bodyType.
     * 
     * @param contentType the contentType value to set.
     * @return the MicrosoftGraphItemBody object itself.
     */
    public MicrosoftGraphItemBody withContentType(MicrosoftGraphBodyType contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the additionalProperties property: itemBody.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: itemBody.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphItemBody object itself.
     */
    public MicrosoftGraphItemBody withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("contentType", this.contentType == null ? null : this.contentType.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphItemBody from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphItemBody if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphItemBody.
     */
    public static MicrosoftGraphItemBody fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphItemBody deserializedMicrosoftGraphItemBody = new MicrosoftGraphItemBody();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("content".equals(fieldName)) {
                    deserializedMicrosoftGraphItemBody.content = reader.getString();
                } else if ("contentType".equals(fieldName)) {
                    deserializedMicrosoftGraphItemBody.contentType
                        = MicrosoftGraphBodyType.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphItemBody.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphItemBody;
        });
    }
}
