// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents an item activity stat.
 */
@Fluent
public final class MicrosoftGraphItemActivityStat extends MicrosoftGraphEntity {
    /*
     * itemActionStat
     */
    private MicrosoftGraphItemActionStat access;

    /*
     * itemActionStat
     */
    private MicrosoftGraphItemActionStat create;

    /*
     * itemActionStat
     */
    private MicrosoftGraphItemActionStat delete;

    /*
     * itemActionStat
     */
    private MicrosoftGraphItemActionStat edit;

    /*
     * When the interval ends. Read-only.
     */
    private OffsetDateTime endDateTime;

    /*
     * incompleteData
     */
    private MicrosoftGraphIncompleteData incompleteData;

    /*
     * Indicates whether the item is 'trending.' Read-only.
     */
    private Boolean isTrending;

    /*
     * itemActionStat
     */
    private MicrosoftGraphItemActionStat move;

    /*
     * When the interval starts. Read-only.
     */
    private OffsetDateTime startDateTime;

    /*
     * Exposes the itemActivities represented in this itemActivityStat resource.
     */
    private List<MicrosoftGraphItemActivity> activities;

    /*
     * itemActivityStat
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphItemActivityStat class.
     */
    public MicrosoftGraphItemActivityStat() {
    }

    /**
     * Get the access property: itemActionStat.
     * 
     * @return the access value.
     */
    public MicrosoftGraphItemActionStat access() {
        return this.access;
    }

    /**
     * Set the access property: itemActionStat.
     * 
     * @param access the access value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withAccess(MicrosoftGraphItemActionStat access) {
        this.access = access;
        return this;
    }

    /**
     * Get the create property: itemActionStat.
     * 
     * @return the create value.
     */
    public MicrosoftGraphItemActionStat create() {
        return this.create;
    }

    /**
     * Set the create property: itemActionStat.
     * 
     * @param create the create value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withCreate(MicrosoftGraphItemActionStat create) {
        this.create = create;
        return this;
    }

    /**
     * Get the delete property: itemActionStat.
     * 
     * @return the delete value.
     */
    public MicrosoftGraphItemActionStat delete() {
        return this.delete;
    }

    /**
     * Set the delete property: itemActionStat.
     * 
     * @param delete the delete value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withDelete(MicrosoftGraphItemActionStat delete) {
        this.delete = delete;
        return this;
    }

    /**
     * Get the edit property: itemActionStat.
     * 
     * @return the edit value.
     */
    public MicrosoftGraphItemActionStat edit() {
        return this.edit;
    }

    /**
     * Set the edit property: itemActionStat.
     * 
     * @param edit the edit value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withEdit(MicrosoftGraphItemActionStat edit) {
        this.edit = edit;
        return this;
    }

    /**
     * Get the endDateTime property: When the interval ends. Read-only.
     * 
     * @return the endDateTime value.
     */
    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    /**
     * Set the endDateTime property: When the interval ends. Read-only.
     * 
     * @param endDateTime the endDateTime value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    /**
     * Get the incompleteData property: incompleteData.
     * 
     * @return the incompleteData value.
     */
    public MicrosoftGraphIncompleteData incompleteData() {
        return this.incompleteData;
    }

    /**
     * Set the incompleteData property: incompleteData.
     * 
     * @param incompleteData the incompleteData value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withIncompleteData(MicrosoftGraphIncompleteData incompleteData) {
        this.incompleteData = incompleteData;
        return this;
    }

    /**
     * Get the isTrending property: Indicates whether the item is 'trending.' Read-only.
     * 
     * @return the isTrending value.
     */
    public Boolean isTrending() {
        return this.isTrending;
    }

    /**
     * Set the isTrending property: Indicates whether the item is 'trending.' Read-only.
     * 
     * @param isTrending the isTrending value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withIsTrending(Boolean isTrending) {
        this.isTrending = isTrending;
        return this;
    }

    /**
     * Get the move property: itemActionStat.
     * 
     * @return the move value.
     */
    public MicrosoftGraphItemActionStat move() {
        return this.move;
    }

    /**
     * Set the move property: itemActionStat.
     * 
     * @param move the move value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withMove(MicrosoftGraphItemActionStat move) {
        this.move = move;
        return this;
    }

    /**
     * Get the startDateTime property: When the interval starts. Read-only.
     * 
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: When the interval starts. Read-only.
     * 
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the activities property: Exposes the itemActivities represented in this itemActivityStat resource.
     * 
     * @return the activities value.
     */
    public List<MicrosoftGraphItemActivity> activities() {
        return this.activities;
    }

    /**
     * Set the activities property: Exposes the itemActivities represented in this itemActivityStat resource.
     * 
     * @param activities the activities value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withActivities(List<MicrosoftGraphItemActivity> activities) {
        this.activities = activities;
        return this;
    }

    /**
     * Get the additionalProperties property: itemActivityStat.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: itemActivityStat.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphItemActivityStat object itself.
     */
    public MicrosoftGraphItemActivityStat withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphItemActivityStat withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (access() != null) {
            access().validate();
        }
        if (create() != null) {
            create().validate();
        }
        if (delete() != null) {
            delete().validate();
        }
        if (edit() != null) {
            edit().validate();
        }
        if (incompleteData() != null) {
            incompleteData().validate();
        }
        if (move() != null) {
            move().validate();
        }
        if (activities() != null) {
            activities().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("access", this.access);
        jsonWriter.writeJsonField("create", this.create);
        jsonWriter.writeJsonField("delete", this.delete);
        jsonWriter.writeJsonField("edit", this.edit);
        jsonWriter.writeStringField("endDateTime",
            this.endDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime));
        jsonWriter.writeJsonField("incompleteData", this.incompleteData);
        jsonWriter.writeBooleanField("isTrending", this.isTrending);
        jsonWriter.writeJsonField("move", this.move);
        jsonWriter.writeStringField("startDateTime",
            this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeArrayField("activities", this.activities, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphItemActivityStat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphItemActivityStat if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphItemActivityStat.
     */
    public static MicrosoftGraphItemActivityStat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphItemActivityStat deserializedMicrosoftGraphItemActivityStat
                = new MicrosoftGraphItemActivityStat();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivityStat.withId(reader.getString());
                } else if ("access".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivityStat.access = MicrosoftGraphItemActionStat.fromJson(reader);
                } else if ("create".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivityStat.create = MicrosoftGraphItemActionStat.fromJson(reader);
                } else if ("delete".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivityStat.delete = MicrosoftGraphItemActionStat.fromJson(reader);
                } else if ("edit".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivityStat.edit = MicrosoftGraphItemActionStat.fromJson(reader);
                } else if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivityStat.endDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("incompleteData".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivityStat.incompleteData
                        = MicrosoftGraphIncompleteData.fromJson(reader);
                } else if ("isTrending".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivityStat.isTrending = reader.getNullable(JsonReader::getBoolean);
                } else if ("move".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivityStat.move = MicrosoftGraphItemActionStat.fromJson(reader);
                } else if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivityStat.startDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("activities".equals(fieldName)) {
                    List<MicrosoftGraphItemActivity> activities
                        = reader.readArray(reader1 -> MicrosoftGraphItemActivity.fromJson(reader1));
                    deserializedMicrosoftGraphItemActivityStat.activities = activities;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphItemActivityStat.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphItemActivityStat;
        });
    }
}
