// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an item action stat.
 */
@Fluent
public final class MicrosoftGraphItemActionStat implements JsonSerializable<MicrosoftGraphItemActionStat> {
    /*
     * The number of times the action took place. Read-only.
     */
    private Integer actionCount;

    /*
     * The number of distinct actors that performed the action. Read-only.
     */
    private Integer actorCount;

    /*
     * itemActionStat
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphItemActionStat class.
     */
    public MicrosoftGraphItemActionStat() {
    }

    /**
     * Get the actionCount property: The number of times the action took place. Read-only.
     * 
     * @return the actionCount value.
     */
    public Integer actionCount() {
        return this.actionCount;
    }

    /**
     * Set the actionCount property: The number of times the action took place. Read-only.
     * 
     * @param actionCount the actionCount value to set.
     * @return the MicrosoftGraphItemActionStat object itself.
     */
    public MicrosoftGraphItemActionStat withActionCount(Integer actionCount) {
        this.actionCount = actionCount;
        return this;
    }

    /**
     * Get the actorCount property: The number of distinct actors that performed the action. Read-only.
     * 
     * @return the actorCount value.
     */
    public Integer actorCount() {
        return this.actorCount;
    }

    /**
     * Set the actorCount property: The number of distinct actors that performed the action. Read-only.
     * 
     * @param actorCount the actorCount value to set.
     * @return the MicrosoftGraphItemActionStat object itself.
     */
    public MicrosoftGraphItemActionStat withActorCount(Integer actorCount) {
        this.actorCount = actorCount;
        return this;
    }

    /**
     * Get the additionalProperties property: itemActionStat.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: itemActionStat.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphItemActionStat object itself.
     */
    public MicrosoftGraphItemActionStat withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("actionCount", this.actionCount);
        jsonWriter.writeNumberField("actorCount", this.actorCount);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphItemActionStat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphItemActionStat if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphItemActionStat.
     */
    public static MicrosoftGraphItemActionStat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphItemActionStat deserializedMicrosoftGraphItemActionStat = new MicrosoftGraphItemActionStat();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("actionCount".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActionStat.actionCount = reader.getNullable(JsonReader::getInt);
                } else if ("actorCount".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActionStat.actorCount = reader.getNullable(JsonReader::getInt);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphItemActionStat.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphItemActionStat;
        });
    }
}
