// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an incomplete data.
 */
@Fluent
public final class MicrosoftGraphIncompleteData implements JsonSerializable<MicrosoftGraphIncompleteData> {
    /*
     * The service does not have source data before the specified time.
     */
    private OffsetDateTime missingDataBeforeDateTime;

    /*
     * Some data was not recorded due to excessive activity.
     */
    private Boolean wasThrottled;

    /*
     * incompleteData
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphIncompleteData class.
     */
    public MicrosoftGraphIncompleteData() {
    }

    /**
     * Get the missingDataBeforeDateTime property: The service does not have source data before the specified time.
     * 
     * @return the missingDataBeforeDateTime value.
     */
    public OffsetDateTime missingDataBeforeDateTime() {
        return this.missingDataBeforeDateTime;
    }

    /**
     * Set the missingDataBeforeDateTime property: The service does not have source data before the specified time.
     * 
     * @param missingDataBeforeDateTime the missingDataBeforeDateTime value to set.
     * @return the MicrosoftGraphIncompleteData object itself.
     */
    public MicrosoftGraphIncompleteData withMissingDataBeforeDateTime(OffsetDateTime missingDataBeforeDateTime) {
        this.missingDataBeforeDateTime = missingDataBeforeDateTime;
        return this;
    }

    /**
     * Get the wasThrottled property: Some data was not recorded due to excessive activity.
     * 
     * @return the wasThrottled value.
     */
    public Boolean wasThrottled() {
        return this.wasThrottled;
    }

    /**
     * Set the wasThrottled property: Some data was not recorded due to excessive activity.
     * 
     * @param wasThrottled the wasThrottled value to set.
     * @return the MicrosoftGraphIncompleteData object itself.
     */
    public MicrosoftGraphIncompleteData withWasThrottled(Boolean wasThrottled) {
        this.wasThrottled = wasThrottled;
        return this;
    }

    /**
     * Get the additionalProperties property: incompleteData.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: incompleteData.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphIncompleteData object itself.
     */
    public MicrosoftGraphIncompleteData withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("missingDataBeforeDateTime",
            this.missingDataBeforeDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.missingDataBeforeDateTime));
        jsonWriter.writeBooleanField("wasThrottled", this.wasThrottled);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphIncompleteData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphIncompleteData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphIncompleteData.
     */
    public static MicrosoftGraphIncompleteData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphIncompleteData deserializedMicrosoftGraphIncompleteData = new MicrosoftGraphIncompleteData();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("missingDataBeforeDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphIncompleteData.missingDataBeforeDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("wasThrottled".equals(fieldName)) {
                    deserializedMicrosoftGraphIncompleteData.wasThrottled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphIncompleteData.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphIncompleteData;
        });
    }
}
