// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an image info.
 */
@Fluent
public final class MicrosoftGraphImageInfo implements JsonSerializable<MicrosoftGraphImageInfo> {
    /*
     * Optional; parameter used to indicate the server is able to render image dynamically in response to
     * parameterization. For example – a high contrast image
     */
    private Boolean addImageQuery;

    /*
     * Optional; alt-text accessible content for the image
     */
    private String alternateText;

    /*
     * The alternativeText property.
     */
    private String alternativeText;

    /*
     * Optional; URI that points to an icon which represents the application used to generate the activity
     */
    private String iconUrl;

    /*
     * imageInfo
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphImageInfo class.
     */
    public MicrosoftGraphImageInfo() {
    }

    /**
     * Get the addImageQuery property: Optional; parameter used to indicate the server is able to render image
     * dynamically in response to parameterization. For example – a high contrast image.
     * 
     * @return the addImageQuery value.
     */
    public Boolean addImageQuery() {
        return this.addImageQuery;
    }

    /**
     * Set the addImageQuery property: Optional; parameter used to indicate the server is able to render image
     * dynamically in response to parameterization. For example – a high contrast image.
     * 
     * @param addImageQuery the addImageQuery value to set.
     * @return the MicrosoftGraphImageInfo object itself.
     */
    public MicrosoftGraphImageInfo withAddImageQuery(Boolean addImageQuery) {
        this.addImageQuery = addImageQuery;
        return this;
    }

    /**
     * Get the alternateText property: Optional; alt-text accessible content for the image.
     * 
     * @return the alternateText value.
     */
    public String alternateText() {
        return this.alternateText;
    }

    /**
     * Set the alternateText property: Optional; alt-text accessible content for the image.
     * 
     * @param alternateText the alternateText value to set.
     * @return the MicrosoftGraphImageInfo object itself.
     */
    public MicrosoftGraphImageInfo withAlternateText(String alternateText) {
        this.alternateText = alternateText;
        return this;
    }

    /**
     * Get the alternativeText property: The alternativeText property.
     * 
     * @return the alternativeText value.
     */
    public String alternativeText() {
        return this.alternativeText;
    }

    /**
     * Set the alternativeText property: The alternativeText property.
     * 
     * @param alternativeText the alternativeText value to set.
     * @return the MicrosoftGraphImageInfo object itself.
     */
    public MicrosoftGraphImageInfo withAlternativeText(String alternativeText) {
        this.alternativeText = alternativeText;
        return this;
    }

    /**
     * Get the iconUrl property: Optional; URI that points to an icon which represents the application used to generate
     * the activity.
     * 
     * @return the iconUrl value.
     */
    public String iconUrl() {
        return this.iconUrl;
    }

    /**
     * Set the iconUrl property: Optional; URI that points to an icon which represents the application used to generate
     * the activity.
     * 
     * @param iconUrl the iconUrl value to set.
     * @return the MicrosoftGraphImageInfo object itself.
     */
    public MicrosoftGraphImageInfo withIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: imageInfo.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: imageInfo.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphImageInfo object itself.
     */
    public MicrosoftGraphImageInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("addImageQuery", this.addImageQuery);
        jsonWriter.writeStringField("alternateText", this.alternateText);
        jsonWriter.writeStringField("alternativeText", this.alternativeText);
        jsonWriter.writeStringField("iconUrl", this.iconUrl);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphImageInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphImageInfo if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphImageInfo.
     */
    public static MicrosoftGraphImageInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphImageInfo deserializedMicrosoftGraphImageInfo = new MicrosoftGraphImageInfo();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("addImageQuery".equals(fieldName)) {
                    deserializedMicrosoftGraphImageInfo.addImageQuery = reader.getNullable(JsonReader::getBoolean);
                } else if ("alternateText".equals(fieldName)) {
                    deserializedMicrosoftGraphImageInfo.alternateText = reader.getString();
                } else if ("alternativeText".equals(fieldName)) {
                    deserializedMicrosoftGraphImageInfo.alternativeText = reader.getString();
                } else if ("iconUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphImageInfo.iconUrl = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphImageInfo.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphImageInfo;
        });
    }
}
