// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an identity set.
 */
@Fluent
public final class MicrosoftGraphIdentitySet implements JsonSerializable<MicrosoftGraphIdentitySet> {
    /*
     * identity
     */
    private MicrosoftGraphIdentity application;

    /*
     * identity
     */
    private MicrosoftGraphIdentity device;

    /*
     * identity
     */
    private MicrosoftGraphIdentity user;

    /*
     * identitySet
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphIdentitySet class.
     */
    public MicrosoftGraphIdentitySet() {
    }

    /**
     * Get the application property: identity.
     * 
     * @return the application value.
     */
    public MicrosoftGraphIdentity application() {
        return this.application;
    }

    /**
     * Set the application property: identity.
     * 
     * @param application the application value to set.
     * @return the MicrosoftGraphIdentitySet object itself.
     */
    public MicrosoftGraphIdentitySet withApplication(MicrosoftGraphIdentity application) {
        this.application = application;
        return this;
    }

    /**
     * Get the device property: identity.
     * 
     * @return the device value.
     */
    public MicrosoftGraphIdentity device() {
        return this.device;
    }

    /**
     * Set the device property: identity.
     * 
     * @param device the device value to set.
     * @return the MicrosoftGraphIdentitySet object itself.
     */
    public MicrosoftGraphIdentitySet withDevice(MicrosoftGraphIdentity device) {
        this.device = device;
        return this;
    }

    /**
     * Get the user property: identity.
     * 
     * @return the user value.
     */
    public MicrosoftGraphIdentity user() {
        return this.user;
    }

    /**
     * Set the user property: identity.
     * 
     * @param user the user value to set.
     * @return the MicrosoftGraphIdentitySet object itself.
     */
    public MicrosoftGraphIdentitySet withUser(MicrosoftGraphIdentity user) {
        this.user = user;
        return this;
    }

    /**
     * Get the additionalProperties property: identitySet.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: identitySet.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphIdentitySet object itself.
     */
    public MicrosoftGraphIdentitySet withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (application() != null) {
            application().validate();
        }
        if (device() != null) {
            device().validate();
        }
        if (user() != null) {
            user().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("application", this.application);
        jsonWriter.writeJsonField("device", this.device);
        jsonWriter.writeJsonField("user", this.user);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphIdentitySet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphIdentitySet if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphIdentitySet.
     */
    public static MicrosoftGraphIdentitySet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphIdentitySet deserializedMicrosoftGraphIdentitySet = new MicrosoftGraphIdentitySet();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("application".equals(fieldName)) {
                    deserializedMicrosoftGraphIdentitySet.application = MicrosoftGraphIdentity.fromJson(reader);
                } else if ("device".equals(fieldName)) {
                    deserializedMicrosoftGraphIdentitySet.device = MicrosoftGraphIdentity.fromJson(reader);
                } else if ("user".equals(fieldName)) {
                    deserializedMicrosoftGraphIdentitySet.user = MicrosoftGraphIdentity.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphIdentitySet.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphIdentitySet;
        });
    }
}
