// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a hashes.
 */
@Fluent
public final class MicrosoftGraphHashes implements JsonSerializable<MicrosoftGraphHashes> {
    /*
     * The CRC32 value of the file in little endian (if available). Read-only.
     */
    private String crc32Hash;

    /*
     * A proprietary hash of the file that can be used to determine if the contents of the file have changed (if
     * available). Read-only.
     */
    private String quickXorHash;

    /*
     * SHA1 hash for the contents of the file (if available). Read-only.
     */
    private String sha1Hash;

    /*
     * SHA256 hash for the contents of the file (if available). Read-only.
     */
    private String sha256Hash;

    /*
     * hashes
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphHashes class.
     */
    public MicrosoftGraphHashes() {
    }

    /**
     * Get the crc32Hash property: The CRC32 value of the file in little endian (if available). Read-only.
     * 
     * @return the crc32Hash value.
     */
    public String crc32Hash() {
        return this.crc32Hash;
    }

    /**
     * Set the crc32Hash property: The CRC32 value of the file in little endian (if available). Read-only.
     * 
     * @param crc32Hash the crc32Hash value to set.
     * @return the MicrosoftGraphHashes object itself.
     */
    public MicrosoftGraphHashes withCrc32Hash(String crc32Hash) {
        this.crc32Hash = crc32Hash;
        return this;
    }

    /**
     * Get the quickXorHash property: A proprietary hash of the file that can be used to determine if the contents of
     * the file have changed (if available). Read-only.
     * 
     * @return the quickXorHash value.
     */
    public String quickXorHash() {
        return this.quickXorHash;
    }

    /**
     * Set the quickXorHash property: A proprietary hash of the file that can be used to determine if the contents of
     * the file have changed (if available). Read-only.
     * 
     * @param quickXorHash the quickXorHash value to set.
     * @return the MicrosoftGraphHashes object itself.
     */
    public MicrosoftGraphHashes withQuickXorHash(String quickXorHash) {
        this.quickXorHash = quickXorHash;
        return this;
    }

    /**
     * Get the sha1Hash property: SHA1 hash for the contents of the file (if available). Read-only.
     * 
     * @return the sha1Hash value.
     */
    public String sha1Hash() {
        return this.sha1Hash;
    }

    /**
     * Set the sha1Hash property: SHA1 hash for the contents of the file (if available). Read-only.
     * 
     * @param sha1Hash the sha1Hash value to set.
     * @return the MicrosoftGraphHashes object itself.
     */
    public MicrosoftGraphHashes withSha1Hash(String sha1Hash) {
        this.sha1Hash = sha1Hash;
        return this;
    }

    /**
     * Get the sha256Hash property: SHA256 hash for the contents of the file (if available). Read-only.
     * 
     * @return the sha256Hash value.
     */
    public String sha256Hash() {
        return this.sha256Hash;
    }

    /**
     * Set the sha256Hash property: SHA256 hash for the contents of the file (if available). Read-only.
     * 
     * @param sha256Hash the sha256Hash value to set.
     * @return the MicrosoftGraphHashes object itself.
     */
    public MicrosoftGraphHashes withSha256Hash(String sha256Hash) {
        this.sha256Hash = sha256Hash;
        return this;
    }

    /**
     * Get the additionalProperties property: hashes.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: hashes.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphHashes object itself.
     */
    public MicrosoftGraphHashes withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("crc32Hash", this.crc32Hash);
        jsonWriter.writeStringField("quickXorHash", this.quickXorHash);
        jsonWriter.writeStringField("sha1Hash", this.sha1Hash);
        jsonWriter.writeStringField("sha256Hash", this.sha256Hash);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphHashes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphHashes if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphHashes.
     */
    public static MicrosoftGraphHashes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphHashes deserializedMicrosoftGraphHashes = new MicrosoftGraphHashes();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("crc32Hash".equals(fieldName)) {
                    deserializedMicrosoftGraphHashes.crc32Hash = reader.getString();
                } else if ("quickXorHash".equals(fieldName)) {
                    deserializedMicrosoftGraphHashes.quickXorHash = reader.getString();
                } else if ("sha1Hash".equals(fieldName)) {
                    deserializedMicrosoftGraphHashes.sha1Hash = reader.getString();
                } else if ("sha256Hash".equals(fieldName)) {
                    deserializedMicrosoftGraphHashes.sha256Hash = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphHashes.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphHashes;
        });
    }
}
