// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a group setting.
 */
@Fluent
public final class MicrosoftGraphGroupSetting extends MicrosoftGraphEntity {
    /*
     * Display name of this group of settings, which comes from the associated template.
     */
    private String displayName;

    /*
     * Unique identifier for the template used to create this group of settings. Read-only.
     */
    private String templateId;

    /*
     * Collection of name value pairs. Must contain and set all the settings defined in the template.
     */
    private List<MicrosoftGraphSettingValue> values;

    /*
     * groupSetting
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphGroupSetting class.
     */
    public MicrosoftGraphGroupSetting() {
    }

    /**
     * Get the displayName property: Display name of this group of settings, which comes from the associated template.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Display name of this group of settings, which comes from the associated template.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphGroupSetting object itself.
     */
    public MicrosoftGraphGroupSetting withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the templateId property: Unique identifier for the template used to create this group of settings. Read-only.
     * 
     * @return the templateId value.
     */
    public String templateId() {
        return this.templateId;
    }

    /**
     * Set the templateId property: Unique identifier for the template used to create this group of settings. Read-only.
     * 
     * @param templateId the templateId value to set.
     * @return the MicrosoftGraphGroupSetting object itself.
     */
    public MicrosoftGraphGroupSetting withTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    /**
     * Get the values property: Collection of name value pairs. Must contain and set all the settings defined in the
     * template.
     * 
     * @return the values value.
     */
    public List<MicrosoftGraphSettingValue> values() {
        return this.values;
    }

    /**
     * Set the values property: Collection of name value pairs. Must contain and set all the settings defined in the
     * template.
     * 
     * @param values the values value to set.
     * @return the MicrosoftGraphGroupSetting object itself.
     */
    public MicrosoftGraphGroupSetting withValues(List<MicrosoftGraphSettingValue> values) {
        this.values = values;
        return this;
    }

    /**
     * Get the additionalProperties property: groupSetting.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: groupSetting.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphGroupSetting object itself.
     */
    public MicrosoftGraphGroupSetting withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphGroupSetting withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (values() != null) {
            values().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("templateId", this.templateId);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphGroupSetting from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphGroupSetting if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphGroupSetting.
     */
    public static MicrosoftGraphGroupSetting fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphGroupSetting deserializedMicrosoftGraphGroupSetting = new MicrosoftGraphGroupSetting();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupSetting.withId(reader.getString());
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupSetting.displayName = reader.getString();
                } else if ("templateId".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupSetting.templateId = reader.getString();
                } else if ("values".equals(fieldName)) {
                    List<MicrosoftGraphSettingValue> values
                        = reader.readArray(reader1 -> MicrosoftGraphSettingValue.fromJson(reader1));
                    deserializedMicrosoftGraphGroupSetting.values = values;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphGroupSetting.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphGroupSetting;
        });
    }
}
