// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a group lifecycle policy.
 */
@Fluent
public final class MicrosoftGraphGroupLifecyclePolicy extends MicrosoftGraphEntity {
    /*
     * List of email address to send notifications for groups without owners. Multiple email address can be defined by
     * separating email address with a semicolon.
     */
    private String alternateNotificationEmails;

    /*
     * Number of days before a group expires and needs to be renewed. Once renewed, the group expiration is extended by
     * the number of days defined.
     */
    private Integer groupLifetimeInDays;

    /*
     * The group type for which the expiration policy applies. Possible values are All, Selected or None.
     */
    private String managedGroupTypes;

    /*
     * groupLifecyclePolicy
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphGroupLifecyclePolicy class.
     */
    public MicrosoftGraphGroupLifecyclePolicy() {
    }

    /**
     * Get the alternateNotificationEmails property: List of email address to send notifications for groups without
     * owners. Multiple email address can be defined by separating email address with a semicolon.
     * 
     * @return the alternateNotificationEmails value.
     */
    public String alternateNotificationEmails() {
        return this.alternateNotificationEmails;
    }

    /**
     * Set the alternateNotificationEmails property: List of email address to send notifications for groups without
     * owners. Multiple email address can be defined by separating email address with a semicolon.
     * 
     * @param alternateNotificationEmails the alternateNotificationEmails value to set.
     * @return the MicrosoftGraphGroupLifecyclePolicy object itself.
     */
    public MicrosoftGraphGroupLifecyclePolicy withAlternateNotificationEmails(String alternateNotificationEmails) {
        this.alternateNotificationEmails = alternateNotificationEmails;
        return this;
    }

    /**
     * Get the groupLifetimeInDays property: Number of days before a group expires and needs to be renewed. Once
     * renewed, the group expiration is extended by the number of days defined.
     * 
     * @return the groupLifetimeInDays value.
     */
    public Integer groupLifetimeInDays() {
        return this.groupLifetimeInDays;
    }

    /**
     * Set the groupLifetimeInDays property: Number of days before a group expires and needs to be renewed. Once
     * renewed, the group expiration is extended by the number of days defined.
     * 
     * @param groupLifetimeInDays the groupLifetimeInDays value to set.
     * @return the MicrosoftGraphGroupLifecyclePolicy object itself.
     */
    public MicrosoftGraphGroupLifecyclePolicy withGroupLifetimeInDays(Integer groupLifetimeInDays) {
        this.groupLifetimeInDays = groupLifetimeInDays;
        return this;
    }

    /**
     * Get the managedGroupTypes property: The group type for which the expiration policy applies. Possible values are
     * All, Selected or None.
     * 
     * @return the managedGroupTypes value.
     */
    public String managedGroupTypes() {
        return this.managedGroupTypes;
    }

    /**
     * Set the managedGroupTypes property: The group type for which the expiration policy applies. Possible values are
     * All, Selected or None.
     * 
     * @param managedGroupTypes the managedGroupTypes value to set.
     * @return the MicrosoftGraphGroupLifecyclePolicy object itself.
     */
    public MicrosoftGraphGroupLifecyclePolicy withManagedGroupTypes(String managedGroupTypes) {
        this.managedGroupTypes = managedGroupTypes;
        return this;
    }

    /**
     * Get the additionalProperties property: groupLifecyclePolicy.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: groupLifecyclePolicy.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphGroupLifecyclePolicy object itself.
     */
    public MicrosoftGraphGroupLifecyclePolicy withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphGroupLifecyclePolicy withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("alternateNotificationEmails", this.alternateNotificationEmails);
        jsonWriter.writeNumberField("groupLifetimeInDays", this.groupLifetimeInDays);
        jsonWriter.writeStringField("managedGroupTypes", this.managedGroupTypes);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphGroupLifecyclePolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphGroupLifecyclePolicy if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphGroupLifecyclePolicy.
     */
    public static MicrosoftGraphGroupLifecyclePolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphGroupLifecyclePolicy deserializedMicrosoftGraphGroupLifecyclePolicy
                = new MicrosoftGraphGroupLifecyclePolicy();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupLifecyclePolicy.withId(reader.getString());
                } else if ("alternateNotificationEmails".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupLifecyclePolicy.alternateNotificationEmails = reader.getString();
                } else if ("groupLifetimeInDays".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupLifecyclePolicy.groupLifetimeInDays
                        = reader.getNullable(JsonReader::getInt);
                } else if ("managedGroupTypes".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupLifecyclePolicy.managedGroupTypes = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphGroupLifecyclePolicy.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphGroupLifecyclePolicy;
        });
    }
}
